/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Math.Tools;
import Catalano.Math.Wavelets.IWavelet;

public class WaveletTransform {
    private IWavelet wavelet;
    private int width;
    private int height;
    private boolean waveletTransformed = false;
    private double[][] data;

    public WaveletTransform(IWavelet wavelet) {
        this.wavelet = wavelet;
    }

    public double[][] getData() {
        return this.data;
    }

    public void setData(double[][] data) {
        this.data = data;
    }

    public boolean isWaveletTransformed() {
        return this.waveletTransformed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void Forward(FastBitmap fastBitmap) {
        this.width = fastBitmap.getWidth();
        this.height = fastBitmap.getHeight();
        if (this.waveletTransformed) return;
        if (fastBitmap.isGrayscale()) {
            if (Tools.isPowerOf2(this.width) && Tools.isPowerOf2(this.height)) {
                this.data = new double[this.height][this.width];
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.width; ++j) {
                        this.data[i][j] = Tools.Scale(0.0f, 255.0f, -1.0f, 1.0f, fastBitmap.getGray(i, j));
                    }
                }
                this.wavelet.Forward(this.data);
                this.waveletTransformed = true;
                return;
            }
            try {
                throw new IllegalArgumentException("Image width and height should be power of 2.");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            throw new IllegalArgumentException("Only grayscale images are supported.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Backward() {
        if (this.waveletTransformed) {
            this.wavelet.Backward(this.data);
            this.waveletTransformed = false;
        }
    }

    public FastBitmap toFastBitmap() {
        FastBitmap l = new FastBitmap(this.width, this.height, FastBitmap.ColorSpace.Grayscale);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                l.setGray(i, j, (int)Tools.Scale(-1.0, 1.0, 0.0, 255.0, this.data[i][j]));
            }
        }
        return l;
    }
}

