/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class VerticalRunLengthSmoothing
implements IApplyInPlace {
    private int maxGapSize = 10;
    private boolean processGapsWithImageBorders = false;

    public int getMaxGapSize() {
        return this.maxGapSize;
    }

    public void setMaxGapSize(int maxGapSize) {
        this.maxGapSize = Math.max(1, Math.min(1000, maxGapSize));
    }

    public boolean isProcessGapsWithImageBorders() {
        return this.processGapsWithImageBorders;
    }

    public void setProcessGapsWithImageBorders(boolean processGapsWithImageBorders) {
        this.processGapsWithImageBorders = processGapsWithImageBorders;
    }

    public VerticalRunLengthSmoothing() {
    }

    public VerticalRunLengthSmoothing(int maxGapSize) {
        this.setMaxGapSize(maxGapSize);
    }

    public VerticalRunLengthSmoothing(int maxGapSize, boolean processGapsWithImageBorders) {
        this.setMaxGapSize(maxGapSize);
        this.setProcessGapsWithImageBorders(processGapsWithImageBorders);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            for (int j = 0; j < width; ++j) {
                int position = 0;
                int columnEndPtr = height;
                int columnStart = position;
                while (position < columnEndPtr) {
                    int gapStart = position;
                    int gapSize = 0;
                    while (position < columnEndPtr && fastBitmap.getGray(position, j) == 0) {
                        ++position;
                        ++gapSize;
                    }
                    if (gapSize <= this.maxGapSize && (this.processGapsWithImageBorders || gapStart != columnStart && position != columnEndPtr)) {
                        while (gapStart < position) {
                            fastBitmap.setGray(gapStart, j, 255);
                            ++gapStart;
                        }
                    }
                    while (position < columnEndPtr && fastBitmap.getGray(position, j) != 0) {
                        ++position;
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("HorizontalRunLengthSmoothing only works in grayscale images.");
        }
    }
}

