/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Opening;
import Catalano.Imaging.Filters.Subtract;
import Catalano.Imaging.IApplyInPlace;

public class TopHat
implements IApplyInPlace {
    private int[][] kernel;
    private int radius;

    public TopHat() {
        this.radius = 1;
    }

    public TopHat(int[][] se) {
        this.kernel = se;
    }

    public TopHat(int radius) {
        this.radius = radius = radius < 1 ? 1 : radius;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (this.radius != 0) {
            this.ApplyInPlace(fastBitmap, this.radius);
        } else {
            this.ApplyInPlace(fastBitmap, this.kernel);
        }
    }

    private void ApplyInPlace(FastBitmap fastBitmap, int radius) {
        FastBitmap l = new FastBitmap(fastBitmap);
        Opening open = new Opening(radius);
        open.applyInPlace(l);
        Subtract sub = new Subtract(l);
        sub.applyInPlace(fastBitmap);
    }

    private void ApplyInPlace(FastBitmap fastBitmap, int[][] se) {
        FastBitmap l = new FastBitmap(fastBitmap);
        Opening open = new Opening(se);
        open.applyInPlace(l);
        Subtract sub = new Subtract(l);
        sub.applyInPlace(fastBitmap);
    }
}

