/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class SobelEdgeDetector
implements IApplyInPlace {
    private boolean scaleIntensity = true;

    public boolean isScaleIntensity() {
        return this.scaleIntensity;
    }

    public void setScaleIntensity(boolean scaleIntensity) {
        this.scaleIntensity = scaleIntensity;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int width = fastBitmap.getWidth() - 2;
            int height = fastBitmap.getHeight() - 2;
            int stride = width;
            int offset = stride + 1;
            FastBitmap copy = new FastBitmap(fastBitmap);
            double max = 0.0;
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int p1 = copy.getGray(offset - stride - 1);
                    int p2 = copy.getGray(offset - stride);
                    int p3 = copy.getGray(offset - stride + 1);
                    int p4 = copy.getGray(offset + 1);
                    int p5 = copy.getGray(offset + stride);
                    int p6 = copy.getGray(offset + stride + 1);
                    int p7 = copy.getGray(offset + stride - 1);
                    int p8 = copy.getGray(offset - 1);
                    double g = Math.min(255, Math.abs(p1 + p3 - p7 - p2 + 2 * (p2 - p5)) + Math.abs(p2 + p6 - p1 - p7 + 2 * (p4 - p8)));
                    if (g > max) {
                        max = g;
                    }
                    fastBitmap.setGray(offset, (int)g);
                    ++offset;
                }
                offset += 2;
            }
            int size = fastBitmap.getSize();
            if (this.scaleIntensity && max != 255.0) {
                double factor = 255.0 / max;
                for (int i = 0; i < size; ++i) {
                    fastBitmap.setGray(i, (int)((double)fastBitmap.getGray(i) * factor));
                }
            }
        } else {
            throw new IllegalArgumentException("SobelEdgeDetector only works in grayscale images.");
        }
    }
}

