/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class SeparableConvolution
implements IApplyInPlace {
    private int width;
    private int height;
    private double[] kernelX;
    private double[] kernelY;
    private boolean replicate = false;

    public boolean isReplicate() {
        return this.replicate;
    }

    public void setReplicate(boolean replicate) {
        this.replicate = replicate;
    }

    public SeparableConvolution() {
    }

    public SeparableConvolution(double[] kernelX, double[] kernelY) {
        this.kernelX = kernelX;
        this.kernelY = kernelY;
    }

    public SeparableConvolution(double[] kernelX, double[] kernelY, boolean replicate) {
        this.kernelX = kernelX;
        this.kernelY = kernelY;
        this.replicate = replicate;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        this.width = fastBitmap.getWidth();
        this.height = fastBitmap.getHeight();
        int lines = (this.kernelX.length - 1) / 2;
        if (fastBitmap.isGrayscale()) {
            int k;
            double gray;
            int j;
            int i;
            double[][] copy = new double[this.height][this.width];
            for (i = 0; i < this.height; ++i) {
                for (j = 0; j < this.width; ++j) {
                    gray = 0.0;
                    for (k = 0; k < this.kernelX.length; ++k) {
                        int Yline = j - lines + k;
                        if (Yline >= 0 && Yline < this.width) {
                            gray += this.kernelX[k] * (double)fastBitmap.getGray(i, Yline);
                            continue;
                        }
                        if (!this.replicate) continue;
                        int c = j + k - lines;
                        if (c < 0) {
                            c = 0;
                        }
                        if (c >= this.width) {
                            c = this.width - 1;
                        }
                        gray += this.kernelX[this.kernelX.length - k - 1] * (double)fastBitmap.getGray(i, c);
                    }
                    copy[i][j] = gray;
                }
            }
            for (i = 0; i < this.height; ++i) {
                for (j = 0; j < this.width; ++j) {
                    gray = 0.0;
                    for (k = 0; k < this.kernelX.length; ++k) {
                        int Xline = i - lines + k;
                        if (Xline >= 0 && Xline < this.height) {
                            gray += this.kernelY[k] * copy[Xline][j];
                            continue;
                        }
                        if (!this.replicate) continue;
                        int r = i + k - lines;
                        if (r < 0) {
                            r = 0;
                        }
                        if (r >= this.height) {
                            r = this.height - 1;
                        }
                        gray += this.kernelY[k] * copy[r][j];
                    }
                    gray = gray < 0.0 ? 0.0 : gray;
                    gray = gray > 255.0 ? 255.0 : gray;
                    fastBitmap.setGray(i, j, (int)gray);
                }
            }
        } else {
            int k;
            double r;
            double g;
            double b;
            int j;
            int i;
            double[][][] copy = new double[this.height][this.width][3];
            for (i = 0; i < this.height; ++i) {
                for (j = 0; j < this.width; ++j) {
                    b = 0.0;
                    g = 0.0;
                    r = 0.0;
                    for (k = 0; k < this.kernelX.length; ++k) {
                        int Yline = j - lines + k;
                        if (Yline >= 0 && Yline < this.width) {
                            r += this.kernelX[k] * (double)fastBitmap.getRed(i, Yline);
                            g += this.kernelX[k] * (double)fastBitmap.getGreen(i, Yline);
                            b += this.kernelX[k] * (double)fastBitmap.getBlue(i, Yline);
                            continue;
                        }
                        if (!this.replicate) continue;
                        int c = j + k - lines;
                        if (c < 0) {
                            c = 0;
                        }
                        if (c >= this.width) {
                            c = this.width - 1;
                        }
                        r += this.kernelX[this.kernelX.length - k - 1] * (double)fastBitmap.getRed(i, c);
                        g += this.kernelX[this.kernelX.length - k - 1] * (double)fastBitmap.getGreen(i, c);
                        b += this.kernelX[this.kernelX.length - k - 1] * (double)fastBitmap.getBlue(i, c);
                    }
                    copy[i][j][0] = r;
                    copy[i][j][1] = g;
                    copy[i][j][2] = b;
                }
            }
            for (i = 0; i < this.height; ++i) {
                for (j = 0; j < this.width; ++j) {
                    b = 0.0;
                    g = 0.0;
                    r = 0.0;
                    for (k = 0; k < this.kernelY.length; ++k) {
                        int Xline = i - lines + k;
                        if (Xline >= 0 && Xline < this.height) {
                            r += this.kernelY[k] * copy[Xline][j][0];
                            g += this.kernelY[k] * copy[Xline][j][1];
                            b += this.kernelY[k] * copy[Xline][j][2];
                            continue;
                        }
                        if (!this.replicate) continue;
                        int rr = i + k - lines;
                        if (rr < 0) {
                            rr = 0;
                        }
                        if (rr >= this.height) {
                            rr = this.height - 1;
                        }
                        r += this.kernelY[k] * copy[rr][j][0];
                        g += this.kernelY[k] * copy[rr][j][1];
                        b += this.kernelY[k] * copy[rr][j][2];
                    }
                    r = r < 0.0 ? 0.0 : r;
                    r = r > 255.0 ? 255.0 : r;
                    g = g < 0.0 ? 0.0 : g;
                    g = g > 255.0 ? 255.0 : g;
                    b = b < 0.0 ? 0.0 : b;
                    b = b > 255.0 ? 255.0 : b;
                    fastBitmap.setRGB(i, j, (int)r, (int)g, (int)b);
                }
            }
        }
    }

    private double SumKernel(double[] h, double[] v) {
        double sum = 0.0;
        for (int i = 0; i < h.length; ++i) {
            for (int j = 0; j < v.length; ++j) {
                sum += h[i] * v[j];
            }
        }
        return sum;
    }
}

