/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Convolution;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.CompassConvolutionKernel;

public class ScharrCompassEdgeDetector
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int j;
        int i;
        int[][] scharr;
        Object image;
        int width;
        int height;
        Convolution c = new Convolution();
        FastBitmap copy = new FastBitmap(fastBitmap);
        if (fastBitmap.isGrayscale()) {
            height = fastBitmap.getHeight();
            width = fastBitmap.getWidth();
            image = new int[height][width];
            scharr = CompassConvolutionKernel.Scharr_North;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = copy.getGray(i, j);
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_Northwest;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_West;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_Southwest;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_South;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_Southeast;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_East;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_Northeast;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            fastBitmap.matrixToImage((int[][])image);
        }
        if (fastBitmap.isRGB()) {
            height = fastBitmap.getHeight();
            width = fastBitmap.getWidth();
            image = new int[height][width][3];
            scharr = CompassConvolutionKernel.Scharr_North;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = copy.getRed(i, j);
                    image[i][j][1] = copy.getGreen(i, j);
                    image[i][j][2] = copy.getBlue(i, j);
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_Northwest;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_West;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_Southwest;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_South;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_Southeast;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_East;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            scharr = CompassConvolutionKernel.Scharr_Northeast;
            c.setKernel(scharr);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            fastBitmap.matrixToImage((int[][][])image);
        }
    }
}

