/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.RotateBicubic;
import Catalano.Imaging.Filters.RotateBilinear;
import Catalano.Imaging.Filters.RotateNearestNeighbor;
import Catalano.Imaging.IApply;
import Catalano.Imaging.IApplyInPlace;

public class Rotate
implements IApply,
IApplyInPlace {
    private double angle;
    private boolean keepSize;
    private Algorithm algorithm;

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public boolean isKeepSize() {
        return this.keepSize;
    }

    public void setKeepSize(boolean keepSize) {
        this.keepSize = keepSize;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public Rotate(double angle) {
        this.angle = angle;
        this.algorithm = Algorithm.NEAREST_NEIGHBOR;
    }

    public Rotate(double angle, boolean keepSize) {
        this.angle = angle;
        this.keepSize = keepSize;
        this.algorithm = Algorithm.NEAREST_NEIGHBOR;
    }

    public Rotate(double angle, Algorithm algorithm) {
        this.angle = angle;
        this.algorithm = algorithm;
    }

    public Rotate(double angle, boolean keepSize, Algorithm algorithm) {
        this.angle = angle;
        this.keepSize = keepSize;
        this.algorithm = algorithm;
    }

    @Override
    public FastBitmap apply(FastBitmap fastBitmap) {
        switch (this.algorithm) {
            case BILINEAR: {
                return new RotateBilinear(this.angle, this.keepSize).apply(fastBitmap);
            }
            case BICUBIC: {
                return new RotateBicubic(this.angle, this.keepSize).apply(fastBitmap);
            }
        }
        return new RotateNearestNeighbor(this.angle, this.keepSize).apply(fastBitmap);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap temp = this.apply(fastBitmap);
        fastBitmap.setImage(temp);
    }

    public static enum Algorithm {
        BILINEAR,
        BICUBIC,
        NEAREST_NEIGHBOR;

    }
}

