/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Convolution;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.CompassConvolutionKernel;

public class RobinsonCompassEdgeDetector
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int j;
        int i;
        int[][] robinson;
        Object image;
        int width;
        int height;
        Convolution c = new Convolution();
        FastBitmap copy = new FastBitmap(fastBitmap);
        if (fastBitmap.isGrayscale()) {
            height = fastBitmap.getHeight();
            width = fastBitmap.getWidth();
            image = new int[height][width];
            robinson = CompassConvolutionKernel.Robinson_North;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = copy.getGray(i, j);
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_Northwest;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_West;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_Southwest;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_South;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_Southeast;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_East;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_Northeast;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            fastBitmap.matrixToImage((int[][])image);
        }
        if (fastBitmap.isRGB()) {
            height = fastBitmap.getHeight();
            width = fastBitmap.getWidth();
            image = new int[height][width][3];
            robinson = CompassConvolutionKernel.Robinson_North;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = copy.getRed(i, j);
                    image[i][j][1] = copy.getGreen(i, j);
                    image[i][j][2] = copy.getBlue(i, j);
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_Northwest;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_West;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_Southwest;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_South;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_Southeast;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_East;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            robinson = CompassConvolutionKernel.Robinson_Northeast;
            c.setKernel(robinson);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            fastBitmap.matrixToImage((int[][][])image);
        }
    }
}

