/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApply;
import Catalano.Imaging.IApplyInPlace;

public class ResizeBilinear
implements IApply,
IApplyInPlace {
    private int newWidth;
    private int newHeight;

    public int getNewWidth() {
        return this.newWidth;
    }

    public void setNewWidth(int newWidth) {
        this.newWidth = newWidth;
    }

    public int getNewHeight() {
        return this.newHeight;
    }

    public void setNewHeight(int newHeight) {
        this.newHeight = newHeight;
    }

    public void setNewSize(int newWidth, int newHeight) {
        this.newWidth = newWidth;
        this.newHeight = newHeight;
    }

    public ResizeBilinear(int newWidth, int newHeight) {
        this.newWidth = newWidth;
        this.newHeight = newHeight;
    }

    @Override
    public FastBitmap apply(FastBitmap fastBitmap) {
        FastBitmap dest = new FastBitmap(this.newWidth, this.newHeight, fastBitmap.getColorSpace());
        if (fastBitmap.isGrayscale()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            double jFactor = (double)width / (double)this.newWidth;
            double iFactor = (double)height / (double)this.newHeight;
            int imax = height - 1;
            int jmax = width - 1;
            for (int i = 0; i < this.newHeight; ++i) {
                double oy = (double)i * iFactor;
                int oy1 = (int)oy;
                int oy2 = oy1 == imax ? oy1 : oy1 + 1;
                double dy1 = oy - (double)oy1;
                double dy2 = 1.0 - dy1;
                int tp1 = oy1;
                int tp2 = oy2;
                for (int j = 0; j < this.newWidth; ++j) {
                    double ox = (double)j * jFactor;
                    int ox1 = (int)ox;
                    int ox2 = ox1 == jmax ? ox1 : ox1 + 1;
                    double dx1 = ox - (double)ox1;
                    double dx2 = 1.0 - dx1;
                    int p1 = fastBitmap.getGray(tp1, ox1);
                    int p2 = fastBitmap.getGray(tp1, ox2);
                    int p3 = fastBitmap.getGray(tp2, ox1);
                    int p4 = fastBitmap.getGray(tp2, ox2);
                    int g = (int)(dy2 * (dx2 * (double)p1 + dx1 * (double)p2) + dy1 * (dx2 * (double)p3 + dx1 * (double)p4));
                    dest.setGray(i, j, g);
                }
            }
            return dest;
        }
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        double jFactor = (double)width / (double)this.newWidth;
        double iFactor = (double)height / (double)this.newHeight;
        int imax = height - 1;
        int jmax = width - 1;
        for (int i = 0; i < this.newHeight; ++i) {
            double oy = (double)i * iFactor;
            int oy1 = (int)oy;
            int oy2 = oy1 == imax ? oy1 : oy1 + 1;
            double dy1 = oy - (double)oy1;
            double dy2 = 1.0 - dy1;
            int tp1 = oy1;
            int tp2 = oy2;
            for (int j = 0; j < this.newWidth; ++j) {
                double ox = (double)j * jFactor;
                int ox1 = (int)ox;
                int ox2 = ox1 == jmax ? ox1 : ox1 + 1;
                double dx1 = ox - (double)ox1;
                double dx2 = 1.0 - dx1;
                int p1 = fastBitmap.getRed(tp1, ox1);
                int p2 = fastBitmap.getRed(tp1, ox2);
                int p3 = fastBitmap.getRed(tp2, ox1);
                int p4 = fastBitmap.getRed(tp2, ox2);
                int r = (int)(dy2 * (dx2 * (double)p1 + dx1 * (double)p2) + dy1 * (dx2 * (double)p3 + dx1 * (double)p4));
                p1 = fastBitmap.getGreen(tp1, ox1);
                p2 = fastBitmap.getGreen(tp1, ox2);
                p3 = fastBitmap.getGreen(tp2, ox1);
                p4 = fastBitmap.getGreen(tp2, ox2);
                int g = (int)(dy2 * (dx2 * (double)p1 + dx1 * (double)p2) + dy1 * (dx2 * (double)p3 + dx1 * (double)p4));
                p1 = fastBitmap.getBlue(tp1, ox1);
                p2 = fastBitmap.getBlue(tp1, ox2);
                p3 = fastBitmap.getBlue(tp2, ox1);
                p4 = fastBitmap.getBlue(tp2, ox2);
                int b = (int)(dy2 * (dx2 * (double)p1 + dx1 * (double)p2) + dy1 * (dx2 * (double)p3 + dx1 * (double)p4));
                dest.setRGB(i, j, r, g, b);
            }
        }
        return dest;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap temp = this.apply(fastBitmap);
        fastBitmap.setImage(temp);
    }
}

