/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.ResizeBicubic;
import Catalano.Imaging.Filters.ResizeBilinear;
import Catalano.Imaging.Filters.ResizeNearestNeighbor;
import Catalano.Imaging.IApply;
import Catalano.Imaging.IApplyInPlace;

public class Resize
implements IApply,
IApplyInPlace {
    private Algorithm algorithm;
    private int newWidth;
    private int newHeight;

    public Resize(int newWidth, int newHeight) {
        this.newWidth = newWidth;
        this.newHeight = newHeight;
        this.algorithm = Algorithm.NEAREST_NEIGHBOR;
    }

    public Resize(int newWidth, int newHeight, Algorithm algorithm) {
        this.newWidth = newWidth;
        this.newHeight = newHeight;
        this.algorithm = algorithm;
    }

    public int getNewHeight() {
        return this.newHeight;
    }

    public void setNewHeight(int newHeight) {
        this.newHeight = newHeight;
    }

    public int getNewWidth() {
        return this.newWidth;
    }

    public void setNewWidth(int newWidth) {
        this.newWidth = newWidth;
    }

    public void setNewSize(int newWidth, int newHeight) {
        this.newWidth = newWidth;
        this.newHeight = newHeight;
    }

    @Override
    public FastBitmap apply(FastBitmap fastBitmap) {
        switch (this.algorithm) {
            case BILINEAR: {
                ResizeBilinear rBilinear = new ResizeBilinear(this.newWidth, this.newHeight);
                return rBilinear.apply(fastBitmap);
            }
            case BICUBIC: {
                ResizeBicubic rBicubic = new ResizeBicubic(this.newWidth, this.newHeight);
                return rBicubic.apply(fastBitmap);
            }
        }
        ResizeNearestNeighbor rNearest = new ResizeNearestNeighbor(this.newWidth, this.newHeight);
        return rNearest.apply(fastBitmap);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        switch (this.algorithm) {
            case BILINEAR: {
                ResizeBilinear rBilinear = new ResizeBilinear(this.newWidth, this.newHeight);
                rBilinear.applyInPlace(fastBitmap);
                break;
            }
            case BICUBIC: {
                ResizeBicubic rBicubic = new ResizeBicubic(this.newWidth, this.newHeight);
                rBicubic.applyInPlace(fastBitmap);
                break;
            }
            case NEAREST_NEIGHBOR: {
                ResizeNearestNeighbor rNearest = new ResizeNearestNeighbor(this.newWidth, this.newHeight);
                rNearest.applyInPlace(fastBitmap);
            }
        }
    }

    public static enum Algorithm {
        BILINEAR,
        BICUBIC,
        NEAREST_NEIGHBOR;

    }
}

