/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.IntRange;
import Catalano.Imaging.FastBitmap;

public class ReplaceColor {
    private int oldRed;
    private int oldGreen;
    private int oldBlue;
    private IntRange oldRedRange;
    private IntRange oldGreenRange;
    private IntRange oldBlueRange;
    private boolean isRange;

    public ReplaceColor(int oldRed, int oldGreen, int oldBlue) {
        this.oldRed = oldRed;
        this.oldGreen = oldGreen;
        this.oldBlue = oldBlue;
        this.isRange = false;
    }

    public ReplaceColor(IntRange oldRed, IntRange oldGreen, IntRange oldBlue) {
        this.oldRedRange = oldRed;
        this.oldGreenRange = oldGreen;
        this.oldBlueRange = oldBlue;
        this.isRange = true;
    }

    public void ApplyInPlace(FastBitmap fastBitmap, int red, int green, int blue) {
        int size = fastBitmap.getSize();
        if (!this.isRange) {
            for (int i = 0; i < size; ++i) {
                int r = fastBitmap.getRed(i);
                int g = fastBitmap.getGreen(i);
                int b = fastBitmap.getBlue(i);
                if (r != this.oldRed || g != this.oldGreen || b != this.oldBlue) continue;
                fastBitmap.setRed(i, red);
                fastBitmap.setGreen(i, green);
                fastBitmap.setBlue(i, blue);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                int r = fastBitmap.getRed(i);
                int g = fastBitmap.getGreen(i);
                int b = fastBitmap.getBlue(i);
                if (r < this.oldRedRange.getMin() || r > this.oldRedRange.getMax() || g < this.oldGreenRange.getMin() || g > this.oldGreenRange.getMax() || b < this.oldBlueRange.getMin() || b > this.oldBlueRange.getMax()) continue;
                fastBitmap.setRed(i, red);
                fastBitmap.setGreen(i, green);
                fastBitmap.setBlue(i, blue);
            }
        }
    }
}

