/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ColorConverter;

public class RGChromaticity
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                double[] color = ColorConverter.RGChromaticity(fastBitmap.getRed(i), fastBitmap.getGreen(i), fastBitmap.getBlue(i));
                fastBitmap.setRGB(i, (int)(color[0] * 255.0), (int)(color[1] * 255.0), (int)(color[2] * 255.0));
            }
        } else {
            try {
                throw new IllegalArgumentException("RGChromaticity only works with RGB images");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

