/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Math.Decompositions.SingularValueDecomposition;
import Catalano.Math.Matrix;
import Catalano.Statistics.Tools;

public class PrincipalComponentTransform {
    private double[][] image;
    private int width;
    private int height;

    public void Compute(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            this.width = fastBitmap.getWidth();
            this.height = fastBitmap.getHeight();
            int size = fastBitmap.getSize();
            this.image = new double[size][3];
            for (int i = 0; i < size; ++i) {
                this.image[i][0] = fastBitmap.getRed(i);
                this.image[i][1] = fastBitmap.getGreen(i);
                this.image[i][2] = fastBitmap.getBlue(i);
            }
        } else {
            throw new IllegalArgumentException("Principal Component Transform only works in RGB images.");
        }
        double[] means = this.getMeans(this.image);
        this.image = this.Center(this.image, means);
        SingularValueDecomposition svd = new SingularValueDecomposition(this.image, false, true);
        this.image = Matrix.Multiply(this.image, svd.getV());
    }

    private double[] getMeans(double[][] matrix) {
        double[] means = new double[matrix[0].length];
        for (int i = 0; i < matrix[0].length; ++i) {
            double[] col = Matrix.getColumn(matrix, i);
            means[i] = Tools.Mean(col);
        }
        return means;
    }

    private double[][] Center(double[][] matrix, double[] means) {
        double[][] m = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[0].length; ++j) {
                m[i][j] = matrix[i][j] - means[j];
            }
        }
        return m;
    }

    public FastBitmap Extract(Component component) {
        if (component == Component.Red) {
            double min = Matrix.Min(Matrix.getColumn(this.image, 0));
            double max = Matrix.Max(Matrix.getColumn(this.image, 0));
            FastBitmap fb = new FastBitmap(this.width, this.height, FastBitmap.ColorSpace.Grayscale);
            int size = this.width * this.height;
            for (int i = 0; i < size; ++i) {
                int c = (int)Catalano.Math.Tools.Scale(min, max, 0.0, 255.0, this.image[i][0]);
                fb.setGray(i, c);
            }
            return fb;
        }
        if (component == Component.Green) {
            double min = Matrix.Min(Matrix.getColumn(this.image, 1));
            double max = Matrix.Max(Matrix.getColumn(this.image, 1));
            FastBitmap fb = new FastBitmap(this.width, this.height, FastBitmap.ColorSpace.Grayscale);
            int size = this.width * this.height;
            for (int i = 0; i < size; ++i) {
                int c = (int)Catalano.Math.Tools.Scale(min, max, 0.0, 255.0, this.image[i][1]);
                fb.setGray(i, c);
            }
            return fb;
        }
        if (component == Component.Blue) {
            double min = Matrix.Min(Matrix.getColumn(this.image, 2));
            double max = Matrix.Max(Matrix.getColumn(this.image, 2));
            FastBitmap fb = new FastBitmap(this.width, this.height, FastBitmap.ColorSpace.Grayscale);
            int size = this.width * this.height;
            for (int i = 0; i < size; ++i) {
                int c = (int)Catalano.Math.Tools.Scale(min, max, 0.0, 255.0, this.image[i][2]);
                fb.setGray(i, c);
            }
            return fb;
        }
        double minRed = Matrix.Min(Matrix.getColumn(this.image, 0));
        double maxRed = Matrix.Max(Matrix.getColumn(this.image, 0));
        double minGreen = Matrix.Min(Matrix.getColumn(this.image, 1));
        double maxGreen = Matrix.Max(Matrix.getColumn(this.image, 1));
        double minBlue = Matrix.Min(Matrix.getColumn(this.image, 2));
        double maxBlue = Matrix.Max(Matrix.getColumn(this.image, 2));
        FastBitmap fb = new FastBitmap(this.width, this.height, FastBitmap.ColorSpace.RGB);
        int size = this.width * this.height;
        for (int i = 0; i < size; ++i) {
            int r = (int)Catalano.Math.Tools.Scale(minRed, maxRed, 0.0, 255.0, this.image[i][0]);
            int g = (int)Catalano.Math.Tools.Scale(minGreen, maxGreen, 0.0, 255.0, this.image[i][1]);
            int b = (int)Catalano.Math.Tools.Scale(minBlue, maxBlue, 0.0, 255.0, this.image[i][2]);
            fb.setRGB(i, r, g, b);
        }
        return fb;
    }

    public static enum Component {
        Red,
        Green,
        Blue,
        RGB;

    }
}

