/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class PoissonNoise
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                int g = fastBitmap.getGray(i);
                g = this.Poisson(g);
                fastBitmap.setGray(i, g);
            }
        } else if (fastBitmap.isRGB()) {
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                int r = fastBitmap.getRed(i);
                int g = fastBitmap.getGreen(i);
                int b = fastBitmap.getBlue(i);
                r = this.Poisson(r);
                g = this.Poisson(g);
                b = this.Poisson(b);
                r = r > 255 ? 255 : r;
                g = g > 255 ? 255 : g;
                b = b > 255 ? 255 : b;
                r = r < 0 ? 0 : r;
                g = g < 0 ? 0 : g;
                b = b < 0 ? 0 : b;
                fastBitmap.setRGB(i, r, g, b);
            }
        } else {
            throw new IllegalArgumentException("Poisson Noise only works in Grayscale and RGB images.");
        }
    }

    private int Poisson(float value) {
        double L = Math.exp(-value);
        int k = 0;
        double p = 1.0;
        do {
            ++k;
        } while ((p *= Math.random()) >= L);
        return k - 1;
    }
}

