/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Photometric;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Photometric.IPhotometricFilter;
import Catalano.Imaging.Tools.ImageUtils;
import Catalano.Imaging.Tools.Kernel;
import Catalano.Math.Functions.Gaussian;
import Catalano.Math.PaddingMatrix;

public class WeberFaces
implements IPhotometricFilter {
    private double sigma;
    private double alpha;
    private int size;
    private double[][] vectors;

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        Gaussian g = new Gaussian(sigma);
        double[][] kernel = g.Kernel2D(2 * (int)Math.ceil(3.0 * sigma) + 1);
        this.sigma = sigma;
        this.vectors = Kernel.Decompose(kernel);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public WeberFaces() {
        this(1.0, 2.0, 9);
    }

    public WeberFaces(double sigma, double alpha, int size) {
        this.setSigma(sigma);
        this.alpha = alpha;
        this.size = size;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Weber Face only works in grayscale images.");
        }
        double[][] image = fastBitmap.toMatrixGrayAsDouble();
        double[][] result = this.Process(image, true);
        fastBitmap.matrixToImage(result);
    }

    public double[][] Process(double[][] image, boolean normalize) {
        ImageUtils.Normalize(image);
        double[][] r = ImageUtils.Convolution(image, this.vectors[0], this.vectors[1]);
        int pad = (int)((Math.sqrt(this.size) - 1.0) / 2.0);
        PaddingMatrix pm = new PaddingMatrix(pad, pad, true);
        r = pm.Create(r);
        double[][] result = new double[image.length][image[0].length];
        for (int i = pad; i < image.length + pad; ++i) {
            for (int j = pad; j < image[0].length + pad; ++j) {
                double sum = 0.0;
                for (int k = i - pad; k <= i + pad; ++k) {
                    for (int l = j - pad; l <= j + pad; ++l) {
                        sum += r[i][j] - r[k][l];
                    }
                }
                result[i - pad][j - pad] = Math.atan(this.alpha * sum / (r[i][j] + 0.01));
            }
        }
        if (normalize) {
            ImageUtils.Normalize(result);
        }
        return result;
    }
}

