/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Photometric;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.GammaCorrection;
import Catalano.Imaging.Filters.Photometric.DifferenceOfGaussian;
import Catalano.Imaging.Filters.Photometric.IPhotometricFilter;
import Catalano.Imaging.Filters.Photometric.RobustPostprocessor;
import Catalano.Imaging.Tools.ImageUtils;

public class TanTriggsNormalization
implements IPhotometricFilter {
    private double gamma;

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public TanTriggsNormalization() {
        this(0.2);
    }

    public TanTriggsNormalization(double gamma) {
        this.gamma = gamma;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Tan Triggs only works in grayscale images.");
        }
        GammaCorrection gc = new GammaCorrection(this.gamma);
        gc.applyInPlace(fastBitmap);
        double[][] image = fastBitmap.toMatrixGrayAsDouble();
        DifferenceOfGaussian dog = new DifferenceOfGaussian(0.5, 2.0);
        image = dog.Process(image, false);
        RobustPostprocessor rp = new RobustPostprocessor();
        image = rp.Process(image);
        ImageUtils.Normalize(image);
    }
}

