/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Photometric;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Photometric.IPhotometricFilter;
import Catalano.Imaging.Tools.ImageUtils;
import Catalano.Imaging.Tools.Kernel;
import Catalano.Math.Matrix;

public class SingleScaleRetinex
implements IPhotometricFilter {
    private double scale;

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public SingleScaleRetinex() {
        this(15.0);
    }

    public SingleScaleRetinex(double scale) {
        this.scale = scale;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Single scale retinex only works in grayscale images.");
        }
        double[][] image = fastBitmap.toMatrixGrayAsDouble();
        image = this.Process(image, true);
        fastBitmap.matrixToImage(image);
    }

    public double[][] Process(double[][] image, boolean normalize) {
        int j;
        int i;
        double[][] g = new double[image.length][image[0].length];
        double c = Math.ceil(image.length / 2);
        double sum = 0.0;
        for (int i2 = 0; i2 < g.length; ++i2) {
            for (int j2 = 0; j2 < g[0].length; ++j2) {
                double radius = (c - (double)i2) * (c - (double)i2) + (c - (double)j2) * (c - (double)j2);
                g[i2][j2] = Math.exp(-(radius / (this.scale * this.scale)));
                sum += g[i2][j2];
            }
        }
        Matrix.Divide(g, sum);
        double[][] vec = Kernel.Decompose(g);
        double[][] r = ImageUtils.Convolution(image, vec[0], vec[1]);
        for (i = 0; i < r.length; ++i) {
            for (j = 0; j < r[0].length; ++j) {
                r[i][j] = Math.ceil(r[i][j]);
                if (r[i][j] != 0.0) continue;
                r[i][j] = 0.01;
            }
        }
        for (i = 0; i < image.length; ++i) {
            for (j = 0; j < image[0].length; ++j) {
                r[i][j] = Math.log(image[i][j] + 0.01) - Math.log(Math.abs(r[i][j]));
            }
        }
        if (normalize) {
            ImageUtils.Normalize(r);
        }
        return r;
    }
}

