/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Photometric;

public class RobustPostprocessor {
    private double alfa;
    private double tao;

    public double getAlfa() {
        return this.alfa;
    }

    public void setAlfa(double alfa) {
        this.alfa = alfa;
    }

    public double getTao() {
        return this.tao;
    }

    public void setTao(double tao) {
        this.tao = tao;
    }

    public RobustPostprocessor() {
        this(0.1, 10.0);
    }

    public RobustPostprocessor(double alfa, double tao) {
        this.alfa = alfa;
        this.tao = tao;
    }

    public double[][] Process(double[][] image) {
        int j;
        int i;
        double mean = 0.0;
        for (i = 0; i < image.length; ++i) {
            for (j = 0; j < image[0].length; ++j) {
                mean += Math.pow(Math.abs(image[i][j]), this.alfa);
            }
        }
        mean /= (double)(image.length * image[0].length);
        mean = Math.pow(mean, 1.0 / this.alfa);
        for (i = 0; i < image.length; ++i) {
            j = 0;
            while (j < image[0].length) {
                double[] dArray = image[i];
                int n = j++;
                dArray[n] = dArray[n] / mean;
            }
        }
        mean = 0.0;
        for (i = 0; i < image.length; ++i) {
            for (j = 0; j < image[0].length; ++j) {
                mean += Math.pow(Math.min(Math.abs(image[i][j]), this.tao), this.alfa);
            }
        }
        mean /= (double)(image.length * image[0].length);
        mean = Math.pow(mean, 1.0 / this.alfa);
        for (i = 0; i < image.length; ++i) {
            j = 0;
            while (j < image[0].length) {
                double[] dArray = image[i];
                int n = j++;
                dArray[n] = dArray[n] / mean;
            }
        }
        double[][] result = new double[image.length][image[0].length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            for (int j2 = 0; j2 < result[0].length; ++j2) {
                result[i2][j2] = this.tao * Math.tanh(image[i2][j2] / this.tao);
            }
        }
        return result;
    }
}

