/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Photometric;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Photometric.DifferenceOfGaussian;
import Catalano.Imaging.Filters.Photometric.IPhotometricFilter;
import Catalano.Imaging.Tools.ImageUtils;
import Catalano.Math.Functions.Gaussian;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;

public class RetinaModel
implements IPhotometricFilter {
    private double sigma1;
    private double sigma2;
    private double dogSigma1;
    private double dogSigma2;
    private double threshold;

    public double getSigma1() {
        return this.sigma1;
    }

    public void setSigma1(double sigma1) {
        this.sigma1 = sigma1;
    }

    public double getSigma2() {
        return this.sigma2;
    }

    public void setSigma2(double sigma2) {
        this.sigma2 = sigma2;
    }

    public double getDogSigma1() {
        return this.dogSigma1;
    }

    public void setDogSigma1(double dogSigma1) {
        this.dogSigma1 = dogSigma1;
    }

    public double getDogSigma2() {
        return this.dogSigma2;
    }

    public void setDogSigma2(double dogSigma2) {
        this.dogSigma2 = dogSigma2;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public RetinaModel() {
        this(1.0, 3.0, 0.5, 4.0, 5.0);
    }

    public RetinaModel(double sigma1, double sigma2, double dogSigma1, double dogSigma2, double threshold) {
        this.sigma1 = sigma1;
        this.sigma2 = sigma2;
        this.dogSigma1 = dogSigma1;
        this.dogSigma2 = dogSigma2;
        this.threshold = threshold;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int j;
        int i;
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Retina modeling only works in grayscale images.");
        }
        double[][] image = fastBitmap.toMatrixGrayAsDouble();
        ImageUtils.Normalize(image);
        int size1 = 2 * (int)Math.ceil(3.0 * this.sigma1) + 1;
        Gaussian ga = new Gaussian(this.sigma1);
        double[][] g1 = ga.Kernel2D(size1);
        int size2 = 2 * (int)Math.ceil(3.0 * this.sigma2) + 1;
        ga.setSigma(this.sigma2);
        double[][] g2 = ga.Kernel2D(size2);
        double[][] f = this.NonLinearity(image, g1);
        ImageUtils.Normalize(f);
        f = this.NonLinearity(f, g2);
        DifferenceOfGaussian dog = new DifferenceOfGaussian(this.dogSigma1, this.dogSigma2);
        f = dog.Process(f, false);
        double s = 0.0;
        for (int i2 = 0; i2 < f.length; ++i2) {
            for (int j2 = 0; j2 < f[0].length; ++j2) {
                s += f[i2][j2] * f[i2][j2];
            }
        }
        s /= (double)(f.length * f[0].length);
        s = Math.sqrt(s);
        Matrix.Divide(f, s);
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (i = 0; i < f.length; ++i) {
            for (j = 0; j < f[0].length; ++j) {
                double v = f[i][j];
                v = v > this.threshold ? this.threshold : v;
                f[i][j] = v = v < -this.threshold ? -this.threshold : v;
                min = Math.min(min, v);
                max = Math.max(max, v);
            }
        }
        for (i = 0; i < f.length; ++i) {
            for (j = 0; j < f[0].length; ++j) {
                fastBitmap.setGray(i, j, (int)Tools.Scale(min, max, 0.0, 255.0, f[i][j]));
            }
        }
    }

    private double[][] NonLinearity(double[][] image, double[][] kernel) {
        int j;
        int i;
        double mean = Matrix.Mean(image) / 2.0;
        double max = Matrix.Max(image);
        double[][] c = ImageUtils.Convolution(image, kernel);
        for (i = 0; i < c.length; ++i) {
            for (j = 0; j < c[0].length; ++j) {
                double v = c[i][j] + mean;
                c[i][j] = v > 255.0 ? 255.0 : v;
            }
        }
        for (i = 0; i < c.length; ++i) {
            for (j = 0; j < c[0].length; ++j) {
                c[i][j] = (c[i][j] + max) * (image[i][j] / (image[i][j] + c[i][j]));
            }
        }
        return c;
    }
}

