/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Minimum
implements IApplyInPlace {
    private int radius = 1;

    public Minimum() {
    }

    public Minimum(int radius) {
        this.radius = radius = radius < 1 ? 1 : radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void applyInPlace(FastBitmap sourceImage) {
        int Yline;
        int Xline;
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        FastBitmap copy = new FastBitmap(sourceImage);
        int lines = this.CalcLines(this.radius);
        if (sourceImage.isGrayscale()) {
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int minG = 255;
                    for (int i = 0; i < lines; ++i) {
                        Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            Yline = y + (j - this.radius);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                            minG = Math.min(minG, copy.getGray(Xline, Yline));
                        }
                    }
                    sourceImage.setGray(x, y, minG);
                }
            }
        }
        if (sourceImage.isRGB()) {
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int minB = 255;
                    int minG = 255;
                    int minR = 255;
                    for (int i = 0; i < lines; ++i) {
                        Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            Yline = y + (j - this.radius);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                            minR = Math.min(minR, copy.getRed(Xline, Yline));
                            minG = Math.min(minG, copy.getGreen(Xline, Yline));
                            minB = Math.min(minB, copy.getBlue(Xline, Yline));
                        }
                    }
                    sourceImage.setRGB(x, y, minR, minG, minB);
                }
            }
        }
    }

    private int CalcLines(int radius) {
        return radius * 2 + 1;
    }
}

