/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Maximum
implements IApplyInPlace {
    private int radius = 1;

    public Maximum() {
    }

    public Maximum(int radius) {
        this.radius = radius = radius < 1 ? 1 : radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void applyInPlace(FastBitmap sourceImage) {
        int Yline;
        int Xline;
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        FastBitmap copy = new FastBitmap(sourceImage);
        int lines = this.CalcLines(this.radius);
        if (sourceImage.isGrayscale()) {
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int maxG = 0;
                    for (int i = 0; i < lines; ++i) {
                        Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            Yline = y + (j - this.radius);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                            maxG = Math.max(maxG, copy.getGray(Xline, Yline));
                        }
                    }
                    sourceImage.setGray(x, y, maxG);
                }
            }
        }
        if (sourceImage.isRGB()) {
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int maxB = 0;
                    int maxG = 0;
                    int maxR = 0;
                    for (int i = 0; i < lines; ++i) {
                        Xline = x + (i - this.radius);
                        for (int j = 0; j < lines; ++j) {
                            Yline = y + (j - this.radius);
                            if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                            maxR = Math.max(maxR, copy.getRed(Xline, Yline));
                            maxG = Math.max(maxG, copy.getGreen(Xline, Yline));
                            maxB = Math.max(maxB, copy.getBlue(Xline, Yline));
                        }
                    }
                    sourceImage.setRGB(x, y, maxR, maxG, maxB);
                }
            }
        }
    }

    private int CalcLines(int radius) {
        return radius * 2 + 1;
    }
}

