/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.Curve;

public class LevelsCurve
implements IApplyInPlace {
    private Curve curveRed;
    private Curve curveGreen;
    private Curve curveBlue;
    private Curve curveGray;

    public Curve getCurveRed() {
        return this.curveRed;
    }

    public void setCurveRed(Curve curveRed) {
        this.curveRed = curveRed;
    }

    public Curve getCurveGreen() {
        return this.curveGreen;
    }

    public void setCurveGreen(Curve curveGreen) {
        this.curveGreen = curveGreen;
    }

    public Curve getCurveBlue() {
        return this.curveBlue;
    }

    public void setCurveBlue(Curve curveBlue) {
        this.curveBlue = curveBlue;
    }

    public void setCurve(Curve curveRed, Curve curveGreen, Curve curveBlue) {
        this.curveRed = curveRed;
        this.curveGreen = curveGreen;
        this.curveBlue = curveBlue;
    }

    public Curve getCurveGray() {
        return this.curveGray;
    }

    public void setCurveGray(Curve curveGray) {
        this.curveGray = curveGray;
    }

    public LevelsCurve() {
        this.curveRed = new Curve();
        this.curveGreen = new Curve();
        this.curveBlue = new Curve();
        this.curveGray = new Curve();
    }

    public LevelsCurve(Curve curveGray) {
        this.curveGray = curveGray;
    }

    public LevelsCurve(Curve curveRed, Curve curveGreen, Curve curveBlue) {
        this.curveRed = curveRed;
        this.curveGreen = curveGreen;
        this.curveBlue = curveBlue;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int[] g = this.curveGray.makeLut();
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                fastBitmap.setGray(i, g[fastBitmap.getGreen(i)]);
            }
        } else if (fastBitmap.isRGB()) {
            int[] r = this.curveRed.makeLut();
            int[] g = this.curveGreen.makeLut();
            int[] b = this.curveBlue.makeLut();
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                fastBitmap.setRGB(i, r[fastBitmap.getRed(i)], g[fastBitmap.getGreen(i)], b[fastBitmap.getBlue(i)]);
            }
        } else {
            throw new IllegalArgumentException("Levels Curve only supports grayscale and rgb images.");
        }
    }
}

