/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.CompassConvolutionKernel;

public class IsotropicCompassEdgeDetector
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int j;
        int i;
        Object copy;
        float[][] isotropic;
        Object image;
        int width;
        int height;
        if (fastBitmap.isGrayscale()) {
            height = fastBitmap.getHeight();
            width = fastBitmap.getWidth();
            image = new int[height][width];
            isotropic = CompassConvolutionKernel.Isotropic_North;
            copy = this.Convolution(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = copy[i][j];
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_Northwest;
            copy = this.Convolution(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy[i][j]);
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_West;
            copy = this.Convolution(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy[i][j]);
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_Southwest;
            copy = this.Convolution(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy[i][j]);
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_South;
            copy = this.Convolution(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy[i][j]);
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_Southeast;
            copy = this.Convolution(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy[i][j]);
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_East;
            copy = this.Convolution(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy[i][j]);
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_Northeast;
            copy = this.Convolution(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy[i][j]);
                }
            }
            fastBitmap.matrixToImage((int[][])image);
        }
        if (fastBitmap.isRGB()) {
            height = fastBitmap.getHeight();
            width = fastBitmap.getWidth();
            image = new int[height][width][3];
            isotropic = CompassConvolutionKernel.Isotropic_North;
            copy = this.ConvolutionRGB(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = copy[i][j][0];
                    image[i][j][1] = copy[i][j][1];
                    image[i][j][2] = copy[i][j][2];
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_Northwest;
            copy = this.ConvolutionRGB(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], (int)copy[i][j][0]);
                    image[i][j][1] = Math.max((int)image[i][j][1], (int)copy[i][j][1]);
                    image[i][j][2] = Math.max((int)image[i][j][2], (int)copy[i][j][2]);
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_West;
            copy = this.ConvolutionRGB(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], (int)copy[i][j][0]);
                    image[i][j][1] = Math.max((int)image[i][j][1], (int)copy[i][j][1]);
                    image[i][j][2] = Math.max((int)image[i][j][2], (int)copy[i][j][2]);
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_Southwest;
            copy = this.ConvolutionRGB(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], (int)copy[i][j][0]);
                    image[i][j][1] = Math.max((int)image[i][j][1], (int)copy[i][j][1]);
                    image[i][j][2] = Math.max((int)image[i][j][2], (int)copy[i][j][2]);
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_South;
            copy = this.ConvolutionRGB(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], (int)copy[i][j][0]);
                    image[i][j][1] = Math.max((int)image[i][j][1], (int)copy[i][j][1]);
                    image[i][j][2] = Math.max((int)image[i][j][2], (int)copy[i][j][2]);
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_Southeast;
            copy = this.ConvolutionRGB(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], (int)copy[i][j][0]);
                    image[i][j][1] = Math.max((int)image[i][j][1], (int)copy[i][j][1]);
                    image[i][j][2] = Math.max((int)image[i][j][2], (int)copy[i][j][2]);
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_East;
            copy = this.ConvolutionRGB(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], (int)copy[i][j][0]);
                    image[i][j][1] = Math.max((int)image[i][j][1], (int)copy[i][j][1]);
                    image[i][j][2] = Math.max((int)image[i][j][2], (int)copy[i][j][2]);
                }
            }
            isotropic = CompassConvolutionKernel.Isotropic_Northeast;
            copy = this.ConvolutionRGB(fastBitmap, isotropic);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], (int)copy[i][j][0]);
                    image[i][j][1] = Math.max((int)image[i][j][1], (int)copy[i][j][1]);
                    image[i][j][2] = Math.max((int)image[i][j][2], (int)copy[i][j][2]);
                }
            }
            fastBitmap.matrixToImage((int[][][])image);
        }
    }

    private int[][] Convolution(FastBitmap fastBitmap, float[][] kernel) {
        int height = fastBitmap.getHeight();
        int width = fastBitmap.getWidth();
        int[][] image = new int[height][width];
        int lines = this.CalcLines(kernel);
        for (int x = 1; x < height - 1; ++x) {
            for (int y = 1; y < width - 1; ++y) {
                int gray = 0;
                for (int i = 0; i < kernel.length; ++i) {
                    int Xline = x + (i - lines);
                    for (int j = 0; j < kernel[0].length; ++j) {
                        int Yline = y + (j - lines);
                        if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                        gray = (int)((float)gray + kernel[i][j] * (float)fastBitmap.getGray(Xline, Yline));
                    }
                }
                if (gray < 0) {
                    gray = 0;
                }
                if (gray > 255) {
                    gray = 255;
                }
                image[x][y] = gray;
            }
        }
        return image;
    }

    private int[][][] ConvolutionRGB(FastBitmap fastBitmap, float[][] kernel) {
        int height = fastBitmap.getHeight();
        int width = fastBitmap.getWidth();
        int[][][] image = new int[height][width][3];
        int lines = this.CalcLines(kernel);
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                int b = 0;
                int g = 0;
                int r = 0;
                for (int i = 0; i < kernel.length; ++i) {
                    int Xline = x + (i - lines);
                    for (int j = 0; j < kernel[0].length; ++j) {
                        int Yline = y + (j - lines);
                        if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                        r = (int)((float)r + kernel[i][j] * (float)fastBitmap.getRed(Xline, Yline));
                        g = (int)((float)g + kernel[i][j] * (float)fastBitmap.getGreen(Xline, Yline));
                        b = (int)((float)b + kernel[i][j] * (float)fastBitmap.getBlue(Xline, Yline));
                    }
                }
                if (r < 0) {
                    r = 0;
                }
                if (g < 0) {
                    g = 0;
                }
                if (b < 0) {
                    b = 0;
                }
                if (r > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                image[x][y][0] = r;
                image[x][y][1] = g;
                image[x][y][2] = b;
            }
        }
        return image;
    }

    private int CalcLines(float[][] kernel) {
        int lines = (kernel[0].length - 1) / 2;
        return lines;
    }
}

