/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Statistics.Histogram;

public class HorizontalIntensityStatistics {
    private Histogram red;
    private Histogram green;
    private Histogram blue;
    private Histogram gray;

    public HorizontalIntensityStatistics(FastBitmap fastBitmap) {
        this.ProcessImage(fastBitmap);
    }

    public Histogram getGray() {
        return this.gray;
    }

    public Histogram getRed() {
        return this.red;
    }

    public Histogram getGreen() {
        return this.green;
    }

    public Histogram getBlue() {
        return this.blue;
    }

    private void ProcessImage(FastBitmap fastBitmap) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        if (fastBitmap.isGrayscale()) {
            int[] g = new int[width];
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int n = y;
                    g[n] = g[n] + fastBitmap.getGray(x, y);
                }
            }
            this.gray = new Histogram(g);
        }
        if (fastBitmap.isRGB()) {
            int[] r = new int[width];
            int[] g = new int[width];
            int[] b = new int[width];
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int n = y;
                    r[n] = r[n] + fastBitmap.getRed(x, y);
                    int n2 = y;
                    g[n2] = g[n2] + fastBitmap.getGreen(x, y);
                    int n3 = y;
                    b[n3] = b[n3] + fastBitmap.getBlue(x, y);
                }
            }
            this.red = new Histogram(r);
            this.green = new Histogram(g);
            this.blue = new Histogram(b);
        }
    }
}

