/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ImageStatistics;
import Catalano.Statistics.Histogram;

public class HistogramAdjust
implements IApplyInPlace {
    private double tolerance;
    private int min = 0;
    private int max = 255;

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public HistogramAdjust() {
        this(0, 255);
    }

    public HistogramAdjust(double tolerance) {
        this(0, 255, tolerance);
    }

    public HistogramAdjust(int min, int max) {
        this(min, max, 0.01);
    }

    public HistogramAdjust(int min, int max, double tolerance) {
        this.min = min;
        this.max = max;
        this.tolerance = tolerance;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        block11: {
            int i;
            block10: {
                int i2;
                if (!fastBitmap.isGrayscale()) break block10;
                ImageStatistics stat = new ImageStatistics(fastBitmap);
                int[] hist = stat.getHistogramGray().getValues();
                double[] cdf = Histogram.CDF(hist);
                int minV = 255;
                int maxV = 0;
                double maxTolerance = 1.0 - this.tolerance;
                for (i2 = 0; i2 < cdf.length; ++i2) {
                    if (!(cdf[i2] > this.tolerance)) continue;
                    minV = i2;
                    break;
                }
                for (i2 = 0; i2 < cdf.length; ++i2) {
                    if (!(cdf[i2] > maxTolerance)) continue;
                    maxV = i2;
                    break;
                }
                int size = fastBitmap.getSize();
                for (int x = 0; x < size; ++x) {
                    int gray = fastBitmap.getGray(x);
                    double stretch = (double)(gray - minV) / (double)(maxV - minV) * (double)(this.max - this.min) + (double)this.min;
                    fastBitmap.setGray(x, fastBitmap.clampValues((int)stretch, 0, 255));
                }
                break block11;
            }
            if (!fastBitmap.isRGB()) break block11;
            ImageStatistics stat = new ImageStatistics(fastBitmap);
            int[] histR = stat.getHistogramRed().getValues();
            int[] histG = stat.getHistogramGreen().getValues();
            int[] histB = stat.getHistogramBlue().getValues();
            double[] cdfR = Histogram.CDF(histR);
            double[] cdfG = Histogram.CDF(histG);
            double[] cdfB = Histogram.CDF(histB);
            int minV_R = 255;
            int minV_G = 255;
            int minV_B = 255;
            int maxV_R = 0;
            int maxV_G = 0;
            int maxV_B = 0;
            double maxTolerance = 1.0 - this.tolerance;
            for (i = 0; i < cdfR.length; ++i) {
                if (!(cdfR[i] > this.tolerance)) continue;
                minV_R = i;
                break;
            }
            for (i = 0; i < cdfG.length; ++i) {
                if (!(cdfG[i] > this.tolerance)) continue;
                minV_G = i;
                break;
            }
            for (i = 0; i < cdfB.length; ++i) {
                if (!(cdfB[i] > this.tolerance)) continue;
                minV_B = i;
                break;
            }
            for (i = 0; i < cdfR.length; ++i) {
                if (!(cdfR[i] > maxTolerance)) continue;
                maxV_R = i;
                break;
            }
            for (i = 0; i < cdfG.length; ++i) {
                if (!(cdfG[i] > maxTolerance)) continue;
                maxV_G = i;
                break;
            }
            for (i = 0; i < cdfB.length; ++i) {
                if (!(cdfB[i] > maxTolerance)) continue;
                maxV_B = i;
                break;
            }
            int size = fastBitmap.getSize();
            for (int x = 0; x < size; ++x) {
                int r = fastBitmap.getRed(x);
                int g = fastBitmap.getGreen(x);
                int b = fastBitmap.getBlue(x);
                int sR = fastBitmap.clampValues((int)((double)(r - minV_R) / (double)(maxV_R - minV_R) * (double)(this.max - this.min)) + this.min, 0, 255);
                int sG = fastBitmap.clampValues((int)((double)(g - minV_G) / (double)(maxV_G - minV_G) * (double)(this.max - this.min)) + this.min, 0, 255);
                int sB = fastBitmap.clampValues((int)((double)(b - minV_B) / (double)(maxV_B - minV_B) * (double)(this.max - this.min)) + this.min, 0, 255);
                fastBitmap.setRGB(x, sR, sG, sB);
            }
        }
    }
}

