/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.FloatRange;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ColorConverter;

public class HSLLinear
implements IApplyInPlace {
    private FloatRange inLuminance = new FloatRange(0.0f, 1.0f);
    private FloatRange inSaturation = new FloatRange(0.0f, 1.0f);
    private FloatRange outLuminance = new FloatRange(0.0f, 1.0f);
    private FloatRange outSaturation = new FloatRange(0.0f, 1.0f);

    public FloatRange getInLuminance() {
        return this.inLuminance;
    }

    public void setInLuminance(FloatRange inLuminance) {
        this.inLuminance = inLuminance;
    }

    public FloatRange getInSaturation() {
        return this.inSaturation;
    }

    public void setInSaturation(FloatRange inSaturation) {
        this.inSaturation = inSaturation;
    }

    public FloatRange getOutLuminance() {
        return this.outLuminance;
    }

    public void setOutLuminance(FloatRange outLuminance) {
        this.outLuminance = outLuminance;
    }

    public FloatRange getOutSaturation() {
        return this.outSaturation;
    }

    public void setOutSaturation(FloatRange outSaturation) {
        this.outSaturation = outSaturation;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            float kl = 0.0f;
            float bl = 0.0f;
            float ks = 0.0f;
            float bs = 0.0f;
            if (this.inLuminance.getMax() != this.inLuminance.getMin()) {
                kl = (this.outLuminance.getMax() - this.outLuminance.getMin()) / (this.inLuminance.getMax() - this.inLuminance.getMin());
                bl = this.outLuminance.getMin() - kl * this.inLuminance.getMin();
            }
            if (this.inSaturation.getMax() != this.inSaturation.getMin()) {
                ks = (this.outSaturation.getMax() - this.outSaturation.getMin()) / (this.inSaturation.getMax() - this.inSaturation.getMin());
                bs = this.outSaturation.getMin() - ks * this.inSaturation.getMin();
            }
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                int b;
                int g;
                int r = fastBitmap.getRed(i);
                double[] hsl = ColorConverter.RGBtoHSL(r, g = fastBitmap.getGreen(i), b = fastBitmap.getBlue(i));
                hsl[2] = hsl[2] >= (double)this.inLuminance.getMax() ? (double)this.outLuminance.getMax() : (hsl[2] <= (double)this.inLuminance.getMin() ? (double)this.outLuminance.getMin() : (double)kl * hsl[2] + (double)bl);
                hsl[1] = hsl[1] >= (double)this.inSaturation.getMax() ? (double)this.outSaturation.getMax() : (hsl[1] <= (double)this.inSaturation.getMin() ? (double)this.outSaturation.getMin() : (double)ks * hsl[1] + (double)bs);
                int[] rgb = ColorConverter.HSLtoRGB(hsl[0], hsl[1], hsl[2]);
                rgb[0] = fastBitmap.clampValues(rgb[0], 0, 255);
                rgb[1] = fastBitmap.clampValues(rgb[1], 0, 255);
                rgb[2] = fastBitmap.clampValues(rgb[2], 0, 255);
                fastBitmap.setRGB(i, rgb);
            }
        }
    }
}

