/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class GrayWorld
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            int size = fastBitmap.getSize();
            double Rmean = 0.0;
            double Gmean = 0.0;
            double Bmean = 0.0;
            for (int i = 0; i < size; ++i) {
                Rmean += (double)fastBitmap.getRed(i);
                Gmean += (double)fastBitmap.getGreen(i);
                Bmean += (double)fastBitmap.getBlue(i);
            }
            double mean = ((Rmean /= (double)size) + (Gmean /= (double)size) + (Bmean /= (double)size)) / 3.0;
            double kr = mean / Rmean;
            double kg = mean / Gmean;
            double kb = mean / Bmean;
            for (int i = 0; i < size; ++i) {
                double r = kr * (double)fastBitmap.getRed(i);
                double g = kg * (double)fastBitmap.getGreen(i);
                double b = kb * (double)fastBitmap.getBlue(i);
                if (r > 255.0) {
                    r = 255.0;
                }
                if (g > 255.0) {
                    g = 255.0;
                }
                if (b > 255.0) {
                    b = 255.0;
                }
                fastBitmap.setRGB(i, (int)r, (int)g, (int)b);
            }
        } else {
            throw new IllegalArgumentException("Gray World only works in RGB images.");
        }
    }
}

