/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import java.util.Random;

public class GaussianNoise
implements IApplyInPlace {
    private double stdDev = 10.0;

    public double getStdDev() {
        return this.stdDev;
    }

    public void setStdDev(double stdDev) {
        this.stdDev = stdDev;
    }

    public GaussianNoise() {
    }

    public GaussianNoise(double stdDev) {
        this.stdDev = stdDev;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int size = fastBitmap.getSize();
            Random r = new Random();
            for (int i = 0; i < size; ++i) {
                int g = fastBitmap.getGray(i);
                g = (g = (int)((double)g + this.stdDev * r.nextGaussian())) > 255 ? 255 : g;
                g = g < 0 ? 0 : g;
                fastBitmap.setGray(i, g);
            }
        } else if (fastBitmap.isRGB()) {
            int size = fastBitmap.getSize();
            Random rand = new Random();
            for (int i = 0; i < size; ++i) {
                int r = fastBitmap.getRed(i);
                int g = fastBitmap.getGreen(i);
                int b = fastBitmap.getBlue(i);
                r = (int)((double)r + this.stdDev * rand.nextGaussian());
                g = (int)((double)g + this.stdDev * rand.nextGaussian());
                b = (int)((double)b + this.stdDev * rand.nextGaussian());
                r = r > 255 ? 255 : r;
                r = r < 0 ? 0 : r;
                g = g > 255 ? 255 : g;
                g = g < 0 ? 0 : g;
                b = b > 255 ? 255 : b;
                b = b < 0 ? 0 : b;
                fastBitmap.setRGB(i, r, g, b);
            }
        } else {
            throw new IllegalArgumentException("Gaussian noise only works in grayscale and rgb images.");
        }
    }
}

