/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class GammaCorrection
implements IApplyInPlace {
    private double gamma;

    public GammaCorrection() {
    }

    public GammaCorrection(double gamma) {
        this.gamma = gamma;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        block3: {
            block2: {
                if (!fastBitmap.isRGB()) break block2;
                int[] gamma_LUT = GammaCorrection.gamma_LUT(this.gamma);
                int size = fastBitmap.getSize();
                for (int i = 0; i < size; ++i) {
                    int r = gamma_LUT[fastBitmap.getRed(i)];
                    int g = gamma_LUT[fastBitmap.getGreen(i)];
                    int b = gamma_LUT[fastBitmap.getBlue(i)];
                    fastBitmap.setRGB(i, r, g, b);
                }
                break block3;
            }
            if (!fastBitmap.isGrayscale()) break block3;
            int[] gamma_LUT = GammaCorrection.gamma_LUT(this.gamma);
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                fastBitmap.setGray(i, gamma_LUT[fastBitmap.getGray(i)]);
            }
        }
    }

    private static int[] gamma_LUT(double gamma_new) {
        int[] gamma_LUT = new int[256];
        for (int i = 0; i < gamma_LUT.length; ++i) {
            gamma_LUT[i] = (int)(255.0 * Math.pow((double)i / 255.0, gamma_new));
        }
        return gamma_LUT;
    }
}

