/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Math.ComplexNumber;
import Catalano.Math.Tools;
import Catalano.Math.Transforms.FourierTransform;

public class FourierTransform {
    private ComplexNumber[][] data;
    private int width;
    private int height;
    private boolean fourierTransformed = false;

    public FourierTransform(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            this.width = fastBitmap.getWidth();
            this.height = fastBitmap.getHeight();
            this.data = new ComplexNumber[this.height][this.width];
            for (int x = 0; x < this.height; ++x) {
                for (int y = 0; y < this.width; ++y) {
                    this.data[x][y] = new ComplexNumber(0.0, 0.0);
                    this.data[x][y].real = fastBitmap.getGray(x, y);
                }
            }
        } else {
            try {
                throw new Exception("FourierTransform works only with Grayscale images");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ComplexNumber[][] getData() {
        return this.data;
    }

    public void setData(ComplexNumber[][] data) {
        this.data = data;
    }

    public boolean isFourierTransformed() {
        return this.fourierTransformed;
    }

    public FastBitmap toFastBitmap() {
        FastBitmap fb = new FastBitmap(this.width, this.height, FastBitmap.ColorSpace.Grayscale);
        if (this.fourierTransformed) {
            int j;
            int i;
            double[][] mag = new double[this.height][this.width];
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            for (i = 0; i < this.height; ++i) {
                for (j = 0; j < this.width; ++j) {
                    mag[i][j] = Math.log(this.data[i][j].getMagnitude() + 1.0);
                    if (mag[i][j] < min) {
                        min = mag[i][j];
                    }
                    if (!(mag[i][j] > max)) continue;
                    max = mag[i][j];
                }
            }
            for (i = 0; i < this.height; ++i) {
                for (j = 0; j < this.width; ++j) {
                    fb.setGray(i, j, (int)Tools.Scale(min, max, 0.0, 255.0, mag[i][j]));
                }
            }
        } else {
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int real = (int)this.data[i][j].real;
                    fb.setGray(i, j, fb.clampValues(real, 0, 255));
                }
            }
        }
        return fb;
    }

    public void Forward() {
        if (!this.fourierTransformed) {
            for (int x = 0; x < this.height; ++x) {
                for (int y = 0; y < this.width; ++y) {
                    if ((x + y & 1) == 0) continue;
                    this.data[x][y].real *= -1.0;
                    this.data[x][y].imaginary *= -1.0;
                }
            }
            Catalano.Math.Transforms.FourierTransform.FFT2(this.data, FourierTransform.Direction.Forward);
            this.fourierTransformed = true;
        }
    }

    public void Backward() {
        if (this.fourierTransformed) {
            Catalano.Math.Transforms.FourierTransform.FFT2(this.data, FourierTransform.Direction.Backward);
            this.fourierTransformed = false;
            for (int x = 0; x < this.height; ++x) {
                for (int y = 0; y < this.width; ++y) {
                    if ((x + y & 1) == 0) continue;
                    this.data[x][y].real *= -1.0;
                    this.data[x][y].imaginary *= -1.0;
                }
            }
        }
    }
}

