/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.IntPoint;
import Catalano.Imaging.Color;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import java.util.LinkedList;

public class FloodFill
implements IApplyInPlace {
    private Algorithm algorithm = Algorithm.FourWay;
    IntPoint startPoint;
    private Color replace;
    private int gray;

    public FloodFill(int x, int y, Color color) {
        this.startPoint = new IntPoint(x, y);
        this.replace = color;
    }

    public FloodFill(int x, int y, int r, int g, int b) {
        this.startPoint = new IntPoint(x, y);
        this.replace = new Color(r, g, b);
    }

    public FloodFill(int x, int y, int r, int g, int b, Algorithm algorithm) {
        this.startPoint = new IntPoint(x, y);
        this.replace = new Color(r, g, b);
        this.algorithm = algorithm;
    }

    public FloodFill(IntPoint p, int r, int g, int b) {
        this.startPoint = p;
        this.replace = new Color(r, g, b);
    }

    public FloodFill(IntPoint p, Color color) {
        this.startPoint = p;
        this.replace = color;
    }

    public FloodFill(IntPoint p, int r, int g, int b, Algorithm algorithm) {
        this.startPoint = p;
        this.replace = new Color(r, g, b);
        this.algorithm = algorithm;
    }

    public FloodFill(int x, int y, int gray) {
        this.startPoint = new IntPoint(x, y);
        this.gray = gray;
    }

    public FloodFill(int x, int y, int gray, Algorithm algorithm) {
        this.startPoint = new IntPoint(x, y);
        this.algorithm = algorithm;
    }

    public FloodFill(IntPoint p, int gray) {
        this.startPoint = p;
        this.gray = gray;
    }

    public FloodFill(IntPoint p, int gray, Algorithm algorithm) {
        this.startPoint = p;
        this.gray = gray;
        this.algorithm = algorithm;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void setRGB(int r, int g, int b) {
        this.replace = new Color(r, g, b);
    }

    public IntPoint getPoint() {
        return this.startPoint;
    }

    public void setPoint(int x, int y) {
        this.startPoint = new IntPoint(x, y);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            LinkedList<IntPoint> examList = new LinkedList<IntPoint>();
            Color old = new Color(fastBitmap.getRGB(this.startPoint));
            switch (this.algorithm) {
                case FourWay: {
                    if (Color.isEqual(old, this.replace)) break;
                    examList.addFirst(new IntPoint(this.startPoint));
                    while (examList.size() > 0) {
                        IntPoint p = (IntPoint)examList.removeLast();
                        Color temp = new Color(fastBitmap.getRGB(p));
                        if (!Color.isEqual(old, temp)) continue;
                        int x = p.x;
                        int y = p.y;
                        fastBitmap.setRGB(x, y, this.replace);
                        if (y - 1 >= 0) {
                            examList.addFirst(new IntPoint(x, y - 1));
                        }
                        if (y + 1 < width) {
                            examList.addFirst(new IntPoint(x, y + 1));
                        }
                        if (x + 1 < height) {
                            examList.addFirst(new IntPoint(x + 1, y));
                        }
                        if (x - 1 < 0) continue;
                        examList.addFirst(new IntPoint(x - 1, y));
                    }
                    break;
                }
                case EightWay: {
                    if (Color.isEqual(old, this.replace)) break;
                    examList.addFirst(new IntPoint(this.startPoint));
                    while (examList.size() > 0) {
                        IntPoint p = (IntPoint)examList.removeFirst();
                        Color temp = new Color(fastBitmap.getRGB(p));
                        if (!Color.isEqual(old, temp)) continue;
                        int x = p.x;
                        int y = p.y;
                        fastBitmap.setRGB(x, y, this.replace);
                        if (x - 1 >= 0 && y - 1 >= 0) {
                            examList.addFirst(new IntPoint(x - 1, y - 1));
                        }
                        if (x - 1 >= 0) {
                            examList.addFirst(new IntPoint(x - 1, y));
                        }
                        if (x + 1 < height && y + 1 < width) {
                            examList.addFirst(new IntPoint(x + 1, y + 1));
                        }
                        if (y - 1 >= 0) {
                            examList.addFirst(new IntPoint(x, y - 1));
                        }
                        if (y + 1 < width) {
                            examList.addFirst(new IntPoint(x, y + 1));
                        }
                        if (x + 1 < height && y - 1 >= 0) {
                            examList.addFirst(new IntPoint(x + 1, y - 1));
                        }
                        if (x + 1 < height) {
                            examList.addFirst(new IntPoint(x + 1, y));
                        }
                        if (x + 1 >= height || y + 1 >= width) continue;
                        examList.addFirst(new IntPoint(x + 1, y + 1));
                    }
                    break;
                }
            }
        } else if (fastBitmap.isGrayscale()) {
            int _gray;
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            LinkedList<IntPoint> examList = new LinkedList<IntPoint>();
            int iGray = fastBitmap.getGray(this.startPoint);
            int _Gray = _gray = this.gray;
            switch (this.algorithm) {
                case FourWay: {
                    if (iGray == _Gray) break;
                    examList.addFirst(new IntPoint(this.startPoint));
                    while (examList.size() > 0) {
                        IntPoint p = (IntPoint)examList.removeLast();
                        _gray = fastBitmap.getGray(p.x, p.y);
                        _Gray = _gray;
                        if (_Gray != iGray) continue;
                        int x = p.x;
                        int y = p.y;
                        fastBitmap.setGray(x, y, this.gray);
                        if (y - 1 > 0) {
                            examList.addFirst(new IntPoint(x, y - 1));
                        }
                        if (y + 1 < width) {
                            examList.addFirst(new IntPoint(x, y + 1));
                        }
                        if (x + 1 < height) {
                            examList.addFirst(new IntPoint(x + 1, y));
                        }
                        if (x - 1 <= 0) continue;
                        examList.addFirst(new IntPoint(x - 1, y));
                    }
                    break;
                }
                case EightWay: {
                    if (iGray == _Gray) break;
                    examList.addFirst(new IntPoint(this.startPoint));
                    while (examList.size() > 0) {
                        IntPoint p = (IntPoint)examList.pop();
                        _gray = fastBitmap.getGray(p.x, p.y);
                        _Gray = _gray;
                        if (_Gray != iGray) continue;
                        int x = p.x;
                        int y = p.y;
                        fastBitmap.setGray(x, y, this.gray);
                        if (x - 1 > 0 && y - 1 > 0) {
                            examList.addFirst(new IntPoint(x - 1, y - 1));
                        }
                        if (x - 1 > 0) {
                            examList.addFirst(new IntPoint(x - 1, y));
                        }
                        if (x + 1 < height && y + 1 < width) {
                            examList.addFirst(new IntPoint(x + 1, y + 1));
                        }
                        if (y - 1 > 0) {
                            examList.addFirst(new IntPoint(x, y - 1));
                        }
                        if (y + 1 < width) {
                            examList.addFirst(new IntPoint(x, y + 1));
                        }
                        if (x + 1 < height && y - 1 > 0) {
                            examList.addFirst(new IntPoint(x + 1, y - 1));
                        }
                        if (x + 1 < height) {
                            examList.addFirst(new IntPoint(x + 1, y));
                        }
                        if (x + 1 >= height || y + 1 >= width) continue;
                        examList.addFirst(new IntPoint(x + 1, y + 1));
                    }
                    break;
                }
            }
        } else {
            throw new IllegalArgumentException("Flood fill only works in RGB and grayscale images.");
        }
    }

    public static enum Algorithm {
        FourWay,
        EightWay;

    }
}

