/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class FastVariance
implements IApplyInPlace {
    private int radius = 2;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public FastVariance() {
    }

    public FastVariance(int radius) {
        this.setRadius(radius);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int n;
        int y;
        int x;
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        FastBitmap copy = new FastBitmap(fastBitmap);
        if (fastBitmap.isGrayscale()) {
            for (x = 0; x < height; ++x) {
                for (y = 0; y < width; ++y) {
                    n = 0;
                    double sum = 0.0;
                    double sum_sq = 0.0;
                    for (int i = x - this.radius; i <= x + this.radius; ++i) {
                        for (int j = y - this.radius; j <= y + this.radius; ++j) {
                            if (i < 0 || i >= height || j < 0 || j >= width) continue;
                            ++n;
                            double val = copy.getGray(i, j);
                            sum += val;
                            sum_sq += val * val;
                        }
                    }
                    double mean = sum / (double)n;
                    double var = sum_sq / (double)n - mean * mean;
                    if (var < 0.0) {
                        var = 0.0;
                    }
                    if (var > 255.0) {
                        var = 255.0;
                    }
                    fastBitmap.setGray(x, y, (int)var);
                }
            }
        }
        if (fastBitmap.isRGB()) {
            for (x = 0; x < height; ++x) {
                for (y = 0; y < width; ++y) {
                    n = 0;
                    double sumR = 0.0;
                    double sumG = 0.0;
                    double sumB = 0.0;
                    double sq_sumR = 0.0;
                    double sq_sumG = 0.0;
                    double sq_sumB = 0.0;
                    for (int i = x - this.radius; i <= x + this.radius; ++i) {
                        for (int j = y - this.radius; j <= y + this.radius; ++j) {
                            if (i < 0 || i >= height || j < 0 || j >= width) continue;
                            ++n;
                            double r = copy.getRed(i, j);
                            double g = copy.getGreen(i, j);
                            double b = copy.getBlue(i, j);
                            sumR += r;
                            sumG += g;
                            sumB += b;
                            sq_sumR += r * r;
                            sq_sumG += g * g;
                            sq_sumB += b * b;
                        }
                    }
                    double meanR = sumR / (double)n;
                    double meanG = sumG / (double)n;
                    double meanB = sumB / (double)n;
                    double varR = sq_sumR / (double)n - meanR * meanR;
                    double varG = sq_sumG / (double)n - meanG * meanG;
                    double varB = sq_sumB / (double)n - meanB * meanB;
                    if (varR < 0.0) {
                        varR = 0.0;
                    }
                    if (varG < 0.0) {
                        varG = 0.0;
                    }
                    if (varB < 0.0) {
                        varB = 0.0;
                    }
                    if (varR > 255.0) {
                        varR = 255.0;
                    }
                    if (varG > 255.0) {
                        varG = 255.0;
                    }
                    if (varB > 255.0) {
                        varB = 255.0;
                    }
                    fastBitmap.setRGB(x, y, (int)varR, (int)varG, (int)varB);
                }
            }
        }
    }
}

