/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IExtract;

public class ExtractNormalizedRGBChannel
implements IExtract {
    private Channel rgb;

    public ExtractNormalizedRGBChannel(Channel rgb) {
        this.rgb = rgb;
    }

    public Channel getRGB() {
        return this.rgb;
    }

    public void setRGB(Channel rgb) {
        this.rgb = rgb;
    }

    @Override
    public FastBitmap Extract(FastBitmap fastBitmap) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        if (fastBitmap.isGrayscale()) {
            try {
                throw new IllegalArgumentException("Extract Channel works only with RGB images");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FastBitmap l = new FastBitmap(width, height, FastBitmap.ColorSpace.Grayscale);
        switch (this.rgb) {
            case R: {
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        int b;
                        int g;
                        int r = fastBitmap.getRed(x, y);
                        int color = r + (g = fastBitmap.getGreen(x, y)) + (b = fastBitmap.getBlue(x, y));
                        color = color == 0 ? 1 : color;
                        color = 255 * r / color;
                        l.setGray(x, y, color);
                    }
                }
                return l;
            }
            case G: {
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        int b;
                        int g;
                        int r = fastBitmap.getRed(x, y);
                        int color = r + (g = fastBitmap.getGreen(x, y)) + (b = fastBitmap.getBlue(x, y));
                        color = color == 0 ? 1 : color;
                        color = 255 * g / color;
                        l.setGray(x, y, color);
                    }
                }
                return l;
            }
            case B: {
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        int b;
                        int g;
                        int r = fastBitmap.getRed(x, y);
                        int color = r + (g = fastBitmap.getGreen(x, y)) + (b = fastBitmap.getBlue(x, y));
                        color = color == 0 ? 1 : color;
                        color = 255 * b / color;
                        l.setGray(x, y, color);
                    }
                }
                return l;
            }
        }
        return l;
    }

    public static enum Channel {
        R,
        G,
        B;

    }
}

