/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Erosion
implements IApplyInPlace {
    private int radius = 0;
    private int[][] kernel;

    public Erosion() {
        this.radius = 1;
    }

    public Erosion(int radius) {
        this.radius = Math.max(radius, 1);
    }

    public Erosion(int[][] kernel) {
        this.kernel = kernel;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int height = fastBitmap.getHeight();
        int width = fastBitmap.getWidth();
        if (fastBitmap.isGrayscale()) {
            if (this.kernel == null) {
                this.createKernel(this.radius);
            }
            FastBitmap copy = new FastBitmap(fastBitmap);
            int radiusI = (this.kernel.length - 1) / 2;
            int radiusJ = (this.kernel[0].length - 1) / 2;
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int X = 0;
                    int min = 255;
                    for (int x = i - radiusI; x < i + radiusI + 1; ++x) {
                        int Y = 0;
                        for (int y = j - radiusJ; y < j + radiusJ + 1; ++y) {
                            int val;
                            if (x >= 0 && x < height && y >= 0 && y < width && (val = copy.getGray(x, y) - this.kernel[X][Y]) < min) {
                                min = val;
                            }
                            ++Y;
                        }
                        ++X;
                    }
                    min = min < 0 ? 0 : min;
                    fastBitmap.setGray(i, j, min);
                }
            }
        }
        if (fastBitmap.isRGB()) {
            if (this.kernel == null) {
                this.createKernel(this.radius);
            }
            int radiusI = (this.kernel.length - 1) / 2;
            int radiusJ = (this.kernel[0].length - 1) / 2;
            FastBitmap copy = new FastBitmap(fastBitmap);
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int X = 0;
                    int minB = 255;
                    int minG = 255;
                    int minR = 255;
                    for (int x = i - radiusI; x < i + radiusI + 1; ++x) {
                        int Y = 0;
                        for (int y = j - radiusJ; y < j + radiusJ + 1; ++y) {
                            if (x >= 0 && x < height && y >= 0 && y < width) {
                                int valR = copy.getRed(x, y) - this.kernel[X][Y];
                                int valG = copy.getGreen(x, y) - this.kernel[X][Y];
                                int valB = copy.getBlue(x, y) - this.kernel[X][Y];
                                if (valR < minR) {
                                    minR = valR;
                                }
                                if (valG < minG) {
                                    minG = valG;
                                }
                                if (valB < minB) {
                                    minB = valB;
                                }
                            }
                            ++Y;
                        }
                        ++X;
                    }
                    minR = minR < 0 ? 0 : minR;
                    minG = minG < 0 ? 0 : minG;
                    minB = minB < 0 ? 0 : minB;
                    fastBitmap.setRGB(i, j, minR, minG, minB);
                }
            }
        }
    }

    private void createKernel(int radius) {
        int size = radius * 2 + 1;
        this.kernel = new int[size][size];
        for (int i = 0; i < this.kernel.length; ++i) {
            for (int j = 0; j < this.kernel[0].length; ++j) {
                this.kernel[i][j] = 1;
            }
        }
    }
}

