/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Math.Tools;

public class DistanceTransform {
    private float[][] image;
    private float max = 0.0f;
    private IntPoint ued;
    private Distance distance = Distance.Euclidean;

    public float getMaximumDistance() {
        return this.max;
    }

    public IntPoint getUltimateErodedPoint() {
        return this.ued;
    }

    public DistanceTransform() {
    }

    public DistanceTransform(Distance distance) {
        this.distance = distance;
    }

    public float[][] Compute(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int y;
            int x;
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            byte[] bPixels = fastBitmap.getGrayData();
            float[] fPixels = new float[bPixels.length];
            for (int i = 0; i < width * height; ++i) {
                if (bPixels[i] == 0) continue;
                fPixels[i] = Float.MAX_VALUE;
            }
            int[][] pointBufs = new int[2][width];
            for (x = 0; x < width; ++x) {
                pointBufs[0][x] = -1;
                pointBufs[1][x] = -1;
            }
            for (y = 0; y < height; ++y) {
                this.edmLine(bPixels, fPixels, pointBufs, width, y * width, y);
            }
            for (x = 0; x < width; ++x) {
                pointBufs[0][x] = -1;
                pointBufs[1][x] = -1;
            }
            for (y = height - 1; y >= 0; --y) {
                this.edmLine(bPixels, fPixels, pointBufs, width, y * width, y);
            }
            this.image = new float[height][width];
            int p = 0;
            if (this.distance == Distance.Euclidean) {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        this.image[i][j] = fPixels[p] < 0.0f ? 0.0f : (float)Math.sqrt(fPixels[p]);
                        if (this.image[i][j] > this.max) {
                            this.max = this.image[i][j];
                            this.ued = new IntPoint(i, j);
                        }
                        ++p;
                    }
                }
            } else {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        this.image[i][j] = fPixels[p] < 0.0f ? 0.0f : fPixels[p];
                        if (this.image[i][j] > this.max) {
                            this.max = this.image[i][j];
                            this.ued = new IntPoint(i, j);
                        }
                        ++p;
                    }
                }
            }
            return this.image;
        }
        throw new IllegalArgumentException("Distance Transform only works in grayscale images.");
    }

    private void edmLine(byte[] bPixels, float[] fPixels, int[][] pointBufs, int width, int offset, int y) {
        float dist2;
        int pNextDiag;
        int[] points = pointBufs[0];
        int pPrev = -1;
        int pDiag = -1;
        int distSqr = Integer.MAX_VALUE;
        int x = 0;
        while (x < width) {
            pNextDiag = points[x];
            if (bPixels[offset] == 0) {
                points[x] = x | y << 16;
            } else {
                dist2 = this.minDist2(points, pPrev, pDiag, x, y, distSqr, this.distance);
                if (fPixels[offset] > dist2) {
                    fPixels[offset] = dist2;
                }
            }
            pPrev = points[x];
            pDiag = pNextDiag;
            ++x;
            ++offset;
        }
        --offset;
        points = pointBufs[1];
        pPrev = -1;
        pDiag = -1;
        x = width - 1;
        while (x >= 0) {
            pNextDiag = points[x];
            if (bPixels[offset] == 0) {
                points[x] = x | y << 16;
            } else {
                dist2 = this.minDist2(points, pPrev, pDiag, x, y, distSqr, this.distance);
                if (fPixels[offset] > dist2) {
                    fPixels[offset] = dist2;
                }
            }
            pPrev = points[x];
            pDiag = pNextDiag;
            --x;
            --offset;
        }
    }

    private float minDist2(int[] points, int pPrev, int pDiag, int x, int y, int distSqr, Distance distance) {
        int y1;
        int x1;
        int y0;
        int x0;
        int dist1Sqr;
        int p0;
        int nearestPoint = p0 = points[x];
        if (p0 != -1 && (dist1Sqr = this.calcDistance(x, y, x0 = p0 & 0xFFFF, y0 = p0 >> 16 & 0xFFFF, distance)) < distSqr) {
            distSqr = dist1Sqr;
        }
        if (pDiag != p0 && pDiag != -1 && (dist1Sqr = this.calcDistance(x, y, x1 = pDiag & 0xFFFF, y1 = pDiag >> 16 & 0xFFFF, distance)) < distSqr) {
            nearestPoint = pDiag;
            distSqr = dist1Sqr;
        }
        if (pPrev != pDiag && pPrev != -1 && (dist1Sqr = this.calcDistance(x, y, x1 = pPrev & 0xFFFF, y1 = pPrev >> 16 & 0xFFFF, distance)) < distSqr) {
            nearestPoint = pPrev;
            distSqr = dist1Sqr;
        }
        points[x] = nearestPoint;
        return distSqr;
    }

    private int calcDistance(int x, int y, int x0, int y0, Distance distance) {
        int v = 0;
        switch (distance) {
            case Euclidean: {
                v = (x - x0) * (x - x0) + (y - y0) * (y - y0);
                break;
            }
            case Manhattan: {
                v = Math.abs(x - x0) + Math.abs(y - y0);
                break;
            }
            case Chessboard: {
                v = Math.max(Math.abs(x - x0), Math.abs(y - y0));
                break;
            }
            case SquaredEuclidean: {
                v = (x - x0) * (x - x0) + (y - y0) * (y - y0);
            }
        }
        return v;
    }

    public FastBitmap toFastBitmap() {
        int width = this.image[0].length;
        int height = this.image.length;
        FastBitmap fb = new FastBitmap(width, height, FastBitmap.ColorSpace.Grayscale);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                fb.setGray(i, j, (int)Tools.Scale(0.0f, this.max, 0.0f, 255.0f, this.image[i][j]));
            }
        }
        return fb;
    }

    public static enum Distance {
        Chessboard,
        Euclidean,
        Manhattan,
        SquaredEuclidean;

    }
}

