/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Math.Tools;
import Catalano.Math.Transforms.DiscreteCosineTransform;

public class CosineTransform {
    private int width;
    private int height;
    private boolean isTransformed = false;
    private double[][] data;
    private double[][] Power;
    private double PowerMax;
    private int scaleValue = 255;

    public double[][] getData() {
        return this.data;
    }

    public void setData(double[][] data) {
        this.data = data;
    }

    public boolean isWaveletTransformed() {
        return this.isTransformed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void Forward(FastBitmap fastBitmap) {
        this.width = fastBitmap.getWidth();
        this.height = fastBitmap.getHeight();
        if (this.isTransformed) return;
        if (fastBitmap.isGrayscale()) {
            if (Tools.isPowerOf2(this.width) && Tools.isPowerOf2(this.height)) {
                this.data = new double[this.height][this.width];
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.width; ++j) {
                        this.data[i][j] = Tools.Scale(0.0f, 255.0f, 0.0f, 1.0f, fastBitmap.getGray(i, j));
                    }
                }
                DiscreteCosineTransform.Forward(this.data);
                this.isTransformed = true;
                return;
            }
            try {
                throw new IllegalArgumentException("Image width and height should be power of 2.");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            throw new IllegalArgumentException("Only grayscale images are supported.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Backward() {
        if (this.isTransformed) {
            DiscreteCosineTransform.Backward(this.data);
            this.isTransformed = false;
        }
    }

    public FastBitmap toFastBitmap() {
        FastBitmap l = new FastBitmap(this.width, this.height, FastBitmap.ColorSpace.Grayscale);
        this.PowerSpectrum();
        double max = Math.log(this.PowerMax + 1.0);
        double scale = 1.0;
        if (this.scaleValue > 0) {
            scale = (double)this.scaleValue / max;
        }
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                double p = this.Power[i][j];
                double plog = Math.log(p + 1.0);
                l.setGray(i, j, (int)(plog * scale * 255.0));
            }
        }
        return l;
    }

    private void PowerSpectrum() {
        this.Power = new double[this.data.length][this.data[0].length];
        this.PowerMax = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                double p = this.data[i][j];
                if (p < 0.0) {
                    p = -p;
                }
                this.Power[i][j] = p;
                if (!(p > this.PowerMax)) continue;
                this.PowerMax = p;
            }
        }
    }
}

