/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Grayscale;
import Catalano.Imaging.IApplyInPlace;

public class Clahe
implements IApplyInPlace {
    private int blockRadius = 63;
    private int bins = 255;
    private float slope = 3.0f;
    private Grayscale.Algorithm algorithm = Grayscale.Algorithm.Average;

    public int getBlockRadius() {
        return this.blockRadius;
    }

    public void setBlockRadius(int blockRadius) {
        this.blockRadius = blockRadius;
    }

    public int getBins() {
        return this.bins;
    }

    public void setBins(int bins) {
        this.bins = bins;
    }

    public float getSlope() {
        return this.slope;
    }

    public void setSlope(float slope) {
        this.slope = slope;
    }

    public Grayscale.Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Grayscale.Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public Clahe() {
    }

    public Clahe(int blockRadius, int bins) {
        this.blockRadius = blockRadius;
        this.bins = bins;
    }

    public Clahe(int blockRadius, int bins, float slope) {
        this.blockRadius = blockRadius;
        this.bins = bins;
        this.slope = slope;
    }

    public Clahe(int blockRadius, int bins, float slope, Grayscale.Algorithm algorithm) {
        this.blockRadius = blockRadius;
        this.bins = bins;
        this.slope = slope;
        this.algorithm = algorithm;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        if (fastBitmap.isGrayscale()) {
            for (int i = 0; i < height; ++i) {
                int[][] result = new int[height][width];
                int iMin = Math.max(0, i - this.blockRadius);
                int iMax = Math.min(height, i + this.blockRadius + 1);
                int h = iMax - iMin;
                int jMin = Math.max(0, -this.blockRadius);
                int jMax = Math.min(width - 1, this.blockRadius);
                int[] hist = new int[this.bins + 1];
                int[] clippedHist = new int[this.bins + 1];
                for (int k = iMin; k < iMax; ++k) {
                    for (int l = jMin; l < jMax; ++l) {
                        int n = this.roundPositive((float)fastBitmap.getGray(k, l) / 255.0f * (float)this.bins);
                        hist[n] = hist[n] + 1;
                    }
                }
                for (int j = 0; j < width; ++j) {
                    int z;
                    int z2;
                    int clippedEntriesBefore;
                    int yi;
                    int v = this.roundPositive((float)fastBitmap.getGray(i, j) / 255.0f * (float)this.bins);
                    int xMin = Math.max(0, j - this.blockRadius);
                    int xMax = j + this.blockRadius + 1;
                    int w = Math.min(width, xMax) - xMin;
                    int n = h * w;
                    int limit = (int)(this.slope * (float)n / (float)this.bins + 0.5f);
                    if (xMin > 0) {
                        int xMin1 = xMin - 1;
                        for (yi = iMin; yi < iMax; ++yi) {
                            int n2 = this.roundPositive((float)fastBitmap.getGray(yi, xMin1) / 255.0f * (float)this.bins);
                            hist[n2] = hist[n2] - 1;
                        }
                    }
                    if (xMax <= width) {
                        int xMax1 = xMax - 1;
                        for (yi = iMin; yi < iMax; ++yi) {
                            int n3 = this.roundPositive((float)fastBitmap.getGray(yi, xMax1) / 255.0f * (float)this.bins);
                            hist[n3] = hist[n3] + 1;
                        }
                    }
                    System.arraycopy(hist, 0, clippedHist, 0, hist.length);
                    int clippedEntries = 0;
                    do {
                        clippedEntriesBefore = clippedEntries;
                        clippedEntries = 0;
                        for (int z3 = 0; z3 <= this.bins; ++z3) {
                            int d = clippedHist[z3] - limit;
                            if (d <= 0) continue;
                            clippedEntries += d;
                            clippedHist[z3] = limit;
                        }
                        int d = clippedEntries / (this.bins + 1);
                        int m = clippedEntries % (this.bins + 1);
                        z2 = 0;
                        while (z2 <= this.bins) {
                            int n4 = z2++;
                            clippedHist[n4] = clippedHist[n4] + d;
                        }
                        if (m == 0) continue;
                        int s = this.bins / m;
                        for (z = 0; z <= this.bins; z += s) {
                            int n5 = z;
                            clippedHist[n5] = clippedHist[n5] + 1;
                        }
                    } while (clippedEntries != clippedEntriesBefore);
                    int hMin = this.bins;
                    for (int z4 = 0; z4 < hMin; ++z4) {
                        if (clippedHist[z4] == 0) continue;
                        hMin = z4;
                    }
                    int cdf = 0;
                    for (z2 = hMin; z2 <= v; ++z2) {
                        cdf += clippedHist[z2];
                    }
                    int cdfMax = cdf;
                    for (z = v + 1; z <= this.bins; ++z) {
                        cdfMax += clippedHist[z];
                    }
                    int cdfMin = clippedHist[hMin];
                    result[i][j] = this.roundPositive((float)(cdf - cdfMin) / (float)(cdfMax - cdfMin) * 255.0f);
                }
                for (int a = 0; a < width; ++a) {
                    fastBitmap.setGray(i, a, result[i][a]);
                }
            }
        } else {
            FastBitmap gray = new FastBitmap(fastBitmap);
            Grayscale gs = new Grayscale(this.algorithm);
            gs.applyInPlace(gray);
            int[][] result = new int[height][width];
            for (int i = 0; i < height; ++i) {
                int iMin = Math.max(0, i - this.blockRadius);
                int iMax = Math.min(height, i + this.blockRadius + 1);
                int h = iMax - iMin;
                int jMin = Math.max(0, -this.blockRadius);
                int jMax = Math.min(width - 1, this.blockRadius);
                int[] hist = new int[this.bins + 1];
                int[] clippedHist = new int[this.bins + 1];
                for (int k = iMin; k < iMax; ++k) {
                    for (int l = jMin; l < jMax; ++l) {
                        int n = this.roundPositive((float)gray.getGray(k, l) / 255.0f * (float)this.bins);
                        hist[n] = hist[n] + 1;
                    }
                }
                for (int j = 0; j < width; ++j) {
                    int z;
                    int z5;
                    int clippedEntriesBefore;
                    int yi;
                    int v = this.roundPositive((float)gray.getGray(i, j) / 255.0f * (float)this.bins);
                    int xMin = Math.max(0, j - this.blockRadius);
                    int xMax = j + this.blockRadius + 1;
                    int w = Math.min(width, xMax) - xMin;
                    int n = h * w;
                    int limit = (int)(this.slope * (float)n / (float)this.bins + 0.5f);
                    if (xMin > 0) {
                        int xMin1 = xMin - 1;
                        for (yi = iMin; yi < iMax; ++yi) {
                            int n6 = this.roundPositive((float)gray.getGray(yi, xMin1) / 255.0f * (float)this.bins);
                            hist[n6] = hist[n6] - 1;
                        }
                    }
                    if (xMax <= width) {
                        int xMax1 = xMax - 1;
                        for (yi = iMin; yi < iMax; ++yi) {
                            int n7 = this.roundPositive((float)gray.getGray(yi, xMax1) / 255.0f * (float)this.bins);
                            hist[n7] = hist[n7] + 1;
                        }
                    }
                    System.arraycopy(hist, 0, clippedHist, 0, hist.length);
                    int clippedEntries = 0;
                    do {
                        clippedEntriesBefore = clippedEntries;
                        clippedEntries = 0;
                        for (int z6 = 0; z6 <= this.bins; ++z6) {
                            int d = clippedHist[z6] - limit;
                            if (d <= 0) continue;
                            clippedEntries += d;
                            clippedHist[z6] = limit;
                        }
                        int d = clippedEntries / (this.bins + 1);
                        int m = clippedEntries % (this.bins + 1);
                        z5 = 0;
                        while (z5 <= this.bins) {
                            int n8 = z5++;
                            clippedHist[n8] = clippedHist[n8] + d;
                        }
                        if (m == 0) continue;
                        int s = this.bins / m;
                        for (z = 0; z <= this.bins; z += s) {
                            int n9 = z;
                            clippedHist[n9] = clippedHist[n9] + 1;
                        }
                    } while (clippedEntries != clippedEntriesBefore);
                    int hMin = this.bins;
                    for (int z7 = 0; z7 < hMin; ++z7) {
                        if (clippedHist[z7] == 0) continue;
                        hMin = z7;
                    }
                    int cdf = 0;
                    for (z5 = hMin; z5 <= v; ++z5) {
                        cdf += clippedHist[z5];
                    }
                    int cdfMax = cdf;
                    for (z = v + 1; z <= this.bins; ++z) {
                        cdfMax += clippedHist[z];
                    }
                    int cdfMin = clippedHist[hMin];
                    result[i][j] = this.roundPositive((float)(cdf - cdfMin) / (float)(cdfMax - cdfMin) * 255.0f);
                }
                for (int a = 0; a < width; ++a) {
                    float s = (float)result[i][a] / (float)gray.getGray(i, a);
                    float r = Math.max(0, Math.min(255, this.roundPositive(s * (float)fastBitmap.getRed(i, a))));
                    float g = Math.max(0, Math.min(255, this.roundPositive(s * (float)fastBitmap.getGreen(i, a))));
                    float b = Math.max(0, Math.min(255, this.roundPositive(s * (float)fastBitmap.getBlue(i, a))));
                    fastBitmap.setRGB(i, a, (int)r, (int)g, (int)b);
                }
            }
        }
    }

    private int roundPositive(float a) {
        return (int)(a + 0.5f);
    }
}

