/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.Blob;
import Catalano.Imaging.Tools.BlobDetection;
import java.util.List;

public class BlobsFiltering
implements IApplyInPlace {
    private Filter filter = Filter.Area;
    private Logic logic = Logic.Or;
    private boolean remove;
    private int minArea = 0;
    private int minHeight = 0;
    private int minWidth = 0;

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public int getMinArea() {
        return this.minArea;
    }

    public void setMinArea(int minArea) {
        this.minArea = Math.max(0, minArea);
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public BlobsFiltering() {
    }

    public BlobsFiltering(int minArea) {
        this(minArea, true);
    }

    public BlobsFiltering(int minArea, boolean remove) {
        this.minArea = Math.max(0, minArea);
        this.remove = remove;
        this.filter = Filter.Area;
    }

    public BlobsFiltering(int minWidth, int minHeight) {
        this(minWidth, minHeight, Logic.Or);
    }

    public BlobsFiltering(int minWidth, int minHeight, Logic logic) {
        this(minWidth, minHeight, logic, true);
    }

    public BlobsFiltering(int minWidth, int minHeight, Logic logic, boolean remove) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.filter = Filter.Size;
        this.logic = Logic.Or;
        this.remove = remove;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        List<Blob> blobs = new BlobDetection().ProcessImage(fastBitmap);
        switch (this.filter) {
            case Area: {
                for (int i = 0; i < blobs.size(); ++i) {
                    int area = blobs.get(i).getArea();
                    if (this.remove) {
                        if (area >= this.minArea) continue;
                        for (IntPoint p : blobs.get(i).getPoints()) {
                            fastBitmap.setGray(p.x, p.y, 0);
                        }
                        continue;
                    }
                    if (area <= this.minArea) continue;
                    for (IntPoint p : blobs.get(i).getPoints()) {
                        fastBitmap.setGray(p.x, p.y, 0);
                    }
                }
                break;
            }
            case Size: {
                for (int i = 0; i < blobs.size(); ++i) {
                    int blobWidth = blobs.get(i).getWidth();
                    int blobHeight = blobs.get(i).getHeight();
                    if (this.logic == Logic.Or) {
                        if (this.remove) {
                            if (blobWidth >= this.minWidth && blobHeight >= this.minHeight) continue;
                            for (IntPoint p : blobs.get(i).getPoints()) {
                                fastBitmap.setGray(p.x, p.y, 0);
                            }
                            continue;
                        }
                        if (blobWidth <= this.minWidth && blobHeight <= this.minHeight) continue;
                        for (IntPoint p : blobs.get(i).getPoints()) {
                            fastBitmap.setGray(p.x, p.y, 0);
                        }
                        continue;
                    }
                    if (this.remove) {
                        if (blobWidth >= this.minWidth || blobHeight >= this.minHeight) continue;
                        for (IntPoint p : blobs.get(i).getPoints()) {
                            fastBitmap.setGray(p.x, p.y, 0);
                        }
                        continue;
                    }
                    if (blobWidth <= this.minWidth || blobHeight <= this.minHeight) continue;
                    for (IntPoint p : blobs.get(i).getPoints()) {
                        fastBitmap.setGray(p.x, p.y, 0);
                    }
                }
                break;
            }
        }
    }

    public static enum Logic {
        Or,
        And;

    }

    public static enum Filter {
        Area,
        Size;

    }
}

