/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.BinaryDilatation;
import Catalano.Imaging.Filters.BinaryErosion;
import Catalano.Imaging.IApplyInPlace;

public class BinaryOpening
implements IApplyInPlace {
    private int[][] kernel;
    private int radius = 0;

    public BinaryOpening() {
        this.radius = 1;
    }

    public BinaryOpening(int[][] se) {
        this.kernel = se;
    }

    public BinaryOpening(int radius) {
        this.radius = radius = radius < 1 ? 1 : radius;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            if (this.radius != 0) {
                this.ApplyInPlace(fastBitmap, this.radius);
            } else {
                this.ApplyInPlace(fastBitmap, this.kernel);
            }
        } else {
            throw new IllegalArgumentException("Binary Opening only works in grayscale images.");
        }
    }

    private void ApplyInPlace(FastBitmap fastBitmap, int[][] se) {
        BinaryErosion ero = new BinaryErosion(se);
        BinaryDilatation dil = new BinaryDilatation(se);
        ero.applyInPlace(fastBitmap);
        dil.applyInPlace(fastBitmap);
    }

    private void ApplyInPlace(FastBitmap fastBitmap, int radius) {
        BinaryErosion ero = new BinaryErosion(radius);
        BinaryDilatation dil = new BinaryDilatation(radius);
        ero.applyInPlace(fastBitmap);
        dil.applyInPlace(fastBitmap);
    }
}

