/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Artistic;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Artistic.Blend;
import Catalano.Imaging.Filters.GammaCorrection;
import Catalano.Imaging.Filters.GaussianBlur;
import Catalano.Imaging.Filters.Invert;
import Catalano.Imaging.Filters.SaturationCorrection;
import Catalano.Imaging.IApplyInPlace;

public class PencilSketch
implements IApplyInPlace {
    private int saturationCorrection = -70;
    private double sigma = 1.4;
    private int size = 5;
    private double gamma = -5.0;

    public int getSaturationCorrection() {
        return this.saturationCorrection;
    }

    public void setSaturationCorrection(int saturationCorrection) {
        this.saturationCorrection = saturationCorrection;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public PencilSketch() {
    }

    public PencilSketch(int saturationCorrection, double sigma, int size, double gamma) {
        this.saturationCorrection = saturationCorrection;
        this.sigma = sigma;
        this.size = size;
        this.gamma = gamma;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            FastBitmap layerA = new FastBitmap(fastBitmap);
            FastBitmap layerB = new FastBitmap(fastBitmap);
            SaturationCorrection sc = new SaturationCorrection(this.saturationCorrection);
            sc.applyInPlace(layerA);
            layerB.setImage(layerA);
            Invert i = new Invert();
            i.applyInPlace(layerB);
            GaussianBlur gb = new GaussianBlur(this.sigma, this.size);
            gb.applyInPlace(layerB);
            Blend b = new Blend(layerB, Blend.Algorithm.ColorDodge);
            b.applyInPlace(layerA);
            GammaCorrection gc = new GammaCorrection(this.gamma);
            gc.applyInPlace(layerA);
            b.setAlgorithm(Blend.Algorithm.Overlay);
            b.setOverlay(layerA);
            b.applyInPlace(fastBitmap);
        }
    }
}

