/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Artistic;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Opacity
implements IApplyInPlace {
    private FastBitmap overlay;
    private double p = 0.65;

    public FastBitmap getOverlay() {
        return this.overlay;
    }

    public void setOverlay(FastBitmap overlay) {
        this.overlay = overlay;
    }

    public double getPercentage() {
        return this.p;
    }

    public void setPercentage(double p) {
        this.p = Math.max(0.0, Math.min(1.0, p));
    }

    public Opacity(FastBitmap overlay) {
        this.overlay = overlay;
    }

    public Opacity(FastBitmap overlay, double percentage) {
        this.overlay = overlay;
        this.setPercentage(percentage);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            int size = fastBitmap.getWidth() * fastBitmap.getHeight();
            for (int i = 0; i < size; ++i) {
                double r1 = fastBitmap.getRed(i);
                double g1 = fastBitmap.getGreen(i);
                double b1 = fastBitmap.getBlue(i);
                double r2 = this.overlay.getRed(i);
                double g2 = this.overlay.getGreen(i);
                double b2 = this.overlay.getBlue(i);
                double r = (1.0 - this.p) * r1 + this.p * r2;
                double g = (1.0 - this.p) * g1 + this.p * g2;
                double b = (1.0 - this.p) * b1 + this.p * b2;
                fastBitmap.setRGB(i, (int)r, (int)g, (int)b);
            }
        } else if (fastBitmap.isARGB()) {
            int size = fastBitmap.getWidth() * fastBitmap.getHeight();
            for (int i = 0; i < size; ++i) {
                double a1 = fastBitmap.getAlpha(i);
                double r1 = fastBitmap.getRed(i);
                double g1 = fastBitmap.getGreen(i);
                double b1 = fastBitmap.getBlue(i);
                double a2 = this.overlay.getAlpha(i);
                double r2 = this.overlay.getRed(i);
                double g2 = this.overlay.getGreen(i);
                double b2 = this.overlay.getBlue(i);
                double a = (1.0 - this.p) * a1 + this.p * a2;
                double r = (1.0 - this.p) * r1 + this.p * r2;
                double g = (1.0 - this.p) * g1 + this.p * g2;
                double b = (1.0 - this.p) * b1 + this.p * b2;
                fastBitmap.setARGB(i, (int)a, (int)r, (int)g, (int)b);
            }
        } else {
            throw new IllegalArgumentException("Opacity only works in RGB or ARGB images.");
        }
    }
}

