/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Artistic;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ColorConverter;

public class OilPainting
implements IApplyInPlace {
    private int radius = 2;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(2, radius);
    }

    public OilPainting() {
    }

    public OilPainting(int radius) {
        this.setRadius(radius);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        if (fastBitmap.isGrayscale()) {
            FastBitmap copy = new FastBitmap(fastBitmap);
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int[] intensityCount = new int[256];
                    int[] averageG = new int[256];
                    int maxIntensity = 0;
                    int maxIndex = 0;
                    for (int k = i - this.radius; k < i + this.radius; ++k) {
                        for (int l = j - this.radius; l < j + this.radius; ++l) {
                            int g;
                            if (k <= 0 || k >= height || l <= 0 || l >= width) continue;
                            int n = g = copy.getGray(k, l);
                            intensityCount[n] = intensityCount[n] + 1;
                            int n2 = g;
                            averageG[n2] = averageG[n2] + g;
                            if (intensityCount[g] <= maxIntensity) continue;
                            maxIntensity = intensityCount[g];
                            maxIndex = g;
                        }
                    }
                    fastBitmap.setGray(i, j, averageG[maxIndex] / maxIntensity);
                }
            }
        } else {
            FastBitmap copy = new FastBitmap(fastBitmap);
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int[] intensityCount = new int[256];
                    int[] averageR = new int[256];
                    int[] averageG = new int[256];
                    int[] averageB = new int[256];
                    int maxIntensity = 0;
                    int maxIndex = 0;
                    for (int k = i - this.radius; k < i + this.radius; ++k) {
                        for (int l = j - this.radius; l < j + this.radius; ++l) {
                            int gray;
                            if (k <= 0 || k >= height || l <= 0 || l >= width) continue;
                            int r = copy.getRed(k, l);
                            int g = copy.getGreen(k, l);
                            int b = copy.getBlue(k, l);
                            int n = gray = (int)ColorConverter.RGBtoGrayscale(r, g, b);
                            intensityCount[n] = intensityCount[n] + 1;
                            int n3 = gray;
                            averageR[n3] = averageR[n3] + r;
                            int n4 = gray;
                            averageG[n4] = averageG[n4] + g;
                            int n5 = gray;
                            averageB[n5] = averageB[n5] + b;
                            if (intensityCount[gray] <= maxIntensity) continue;
                            maxIntensity = intensityCount[gray];
                            maxIndex = gray;
                        }
                    }
                    fastBitmap.setRGB(i, j, averageR[maxIndex] / maxIntensity, averageG[maxIndex] / maxIntensity, averageB[maxIndex] / maxIntensity);
                }
            }
        }
    }
}

