/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class ArtifactsRemoval
implements IApplyInPlace {
    private int windowSize = 15;

    public ArtifactsRemoval() {
    }

    public ArtifactsRemoval(int windowSize) {
        this.windowSize = windowSize;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            FastBitmap copy = new FastBitmap(fastBitmap);
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            int steps = this.windowSize / 2;
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    double sum = 0.0;
                    int hits = 0;
                    for (int i = x - steps; i < x + steps; ++i) {
                        for (int j = y - steps; j < y + steps; ++j) {
                            if (i < 0 || j < 0 || i >= height || j >= width) continue;
                            sum += (double)copy.getGray(i, j);
                            ++hits;
                        }
                    }
                    double mean = sum / (double)hits;
                    fastBitmap.setGray(x, y, (int)((double)fastBitmap.getGray(x, y) - mean));
                }
            }
        } else {
            throw new IllegalArgumentException("Artifacts Removal only works in grayscale images.");
        }
    }
}

