/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class AdaptiveContrastEnhancement
implements IApplyInPlace {
    int windowSize;
    double k1;
    double k2;
    double maxGain;
    double minGain;

    public AdaptiveContrastEnhancement(int windowSize, double k1, double k2, double minGain, double maxGain) {
        this.windowSize = windowSize;
        this.k1 = k1;
        this.k2 = k2;
        this.minGain = minGain;
        this.maxGain = maxGain;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int lines = this.CalcLines(this.windowSize);
        FastBitmap copy = new FastBitmap(fastBitmap);
        if (fastBitmap.isGrayscale()) {
            double mean = this.getMean(fastBitmap);
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    double factor;
                    int hits = 0;
                    int windowSize2 = this.windowSize * this.windowSize;
                    int[] values = new int[windowSize2];
                    double sumMean = 0.0;
                    double sumVar = 0.0;
                    for (int i = x - lines; i <= x + lines; ++i) {
                        for (int j = y - lines; j <= y + lines; ++j) {
                            if (i < 0 || i >= height || j < 0 || j >= width) continue;
                            values[hits] = copy.getGray(i, j);
                            sumMean += (double)values[hits];
                            sumVar += (double)(values[hits] * values[hits]);
                            ++hits;
                        }
                    }
                    sumVar /= (double)windowSize2;
                    if ((factor = (sumVar -= (sumMean /= (double)windowSize2) * sumMean) != 0.0 ? this.k1 * (mean / sumVar) : this.maxGain) > this.maxGain) {
                        factor = this.maxGain;
                    }
                    if (factor < this.minGain) {
                        factor = this.minGain;
                    }
                    double gray = factor * ((double)copy.getGray(x, y) - sumMean) + this.k2 * sumMean;
                    fastBitmap.setGray(x, y, (int)gray);
                }
            }
        } else {
            try {
                throw new IllegalArgumentException("AdaptiveContrastEnhancement works only with grayscale.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private double getMean(FastBitmap fastBitmap) {
        int sum = 0;
        for (int i = 0; i < fastBitmap.getHeight(); ++i) {
            for (int j = 0; j < fastBitmap.getWidth(); ++j) {
                sum += fastBitmap.getGray(i, j);
            }
        }
        return sum / (fastBitmap.getWidth() * fastBitmap.getHeight());
    }

    private int CalcLines(int windowSize) {
        return (windowSize - 1) / 2;
    }
}

