/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging;

import Catalano.Core.IntPoint;
import Catalano.Imaging.Color;
import Catalano.Imaging.Filters.Grayscale;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.ImageIcon;
import org.w3c.dom.Element;

public class FastBitmap {
    private BufferedImage bufferedImage;
    private WritableRaster raster;
    private int[] pixels;
    private byte[] pixelsGRAY;
    private CoordinateSystem cSystem = CoordinateSystem.Matrix;
    private int strideX;
    private int strideY;
    private int size;

    public FastBitmap() {
    }

    public FastBitmap(FastBitmap fastBitmap) {
        this.bufferedImage = fastBitmap.toBufferedImage();
        if (this.getType() == 5) {
            this.toRGB();
        }
        this.setCoordinateSystem(fastBitmap.getCoordinateSystem());
        this.refresh();
    }

    public FastBitmap(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
        this.prepare();
        this.refresh();
    }

    public FastBitmap(Image image) {
        this.bufferedImage = (BufferedImage)image;
        this.prepare();
        this.refresh();
    }

    public FastBitmap(ImageIcon ico) {
        this.bufferedImage = (BufferedImage)ico.getImage();
        this.prepare();
        this.refresh();
    }

    public FastBitmap(String pathname) {
        try {
            this.bufferedImage = ImageIO.read(new File(pathname));
            this.prepare();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public FastBitmap(int width, int height) {
        this.bufferedImage = new BufferedImage(width, height, 1);
        this.setCoordinateSystem(CoordinateSystem.Matrix);
        this.refresh();
    }

    public FastBitmap(int width, int height, ColorSpace colorSpace) {
        if (colorSpace == ColorSpace.RGB) {
            this.bufferedImage = new BufferedImage(width, height, 1);
        } else if (colorSpace == ColorSpace.Grayscale) {
            this.bufferedImage = new BufferedImage(width, height, 10);
        } else if (colorSpace == ColorSpace.ARGB) {
            this.bufferedImage = new BufferedImage(width, height, 2);
        }
        this.setCoordinateSystem(CoordinateSystem.Matrix);
        this.refresh();
    }

    public FastBitmap(int[][] image) {
        this.bufferedImage = new BufferedImage(image[0].length, image.length, 10);
        this.setCoordinateSystem(CoordinateSystem.Matrix);
        this.refresh();
        this.matrixToImage(image);
    }

    public FastBitmap(int[][][] image) {
        this.bufferedImage = image[0][0].length == 3 ? new BufferedImage(image[0].length, image.length, 1) : new BufferedImage(image[0].length, image.length, 2);
        this.setCoordinateSystem(CoordinateSystem.Matrix);
        this.refresh();
        this.matrixToImage(image);
    }

    private void prepare() {
        if (this.getType() == 10) {
            this.refresh();
        } else if (this.getType() == 2 || this.getType() == 6) {
            this.toARGB();
        } else {
            this.toRGB();
        }
        this.setCoordinateSystem(CoordinateSystem.Matrix);
    }

    private void refresh() {
        this.raster = this.getRaster();
        if (this.isGrayscale()) {
            this.pixelsGRAY = ((DataBufferByte)this.raster.getDataBuffer()).getData();
            this.size = this.pixelsGRAY.length;
        }
        if (this.isRGB() || this.isARGB()) {
            this.pixels = ((DataBufferInt)this.raster.getDataBuffer()).getData();
            this.size = this.pixels.length;
        }
    }

    public ColorSpace getColorSpace() {
        if (this.getType() == 10) {
            return ColorSpace.Grayscale;
        }
        if (this.getType() == 2) {
            return ColorSpace.ARGB;
        }
        return ColorSpace.RGB;
    }

    public byte[] getGrayData() {
        return this.pixelsGRAY;
    }

    public void setGrayData(byte[] data) {
        this.pixelsGRAY = data;
    }

    public int[] getRGBData() {
        return this.pixels;
    }

    public int getSize() {
        return this.size;
    }

    public void setRGBData(int[] data) {
        this.pixels = data;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
        this.refresh();
    }

    public void setImage(FastBitmap fastBitmap) {
        this.bufferedImage = fastBitmap.toBufferedImage();
        this.setCoordinateSystem(fastBitmap.getCoordinateSystem());
        this.refresh();
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.cSystem;
    }

    public void setCoordinateSystem(CoordinateSystem coSystem) {
        this.cSystem = coSystem;
        if (coSystem == CoordinateSystem.Matrix) {
            this.strideX = this.getWidth();
            this.strideY = 1;
        } else {
            this.strideX = 1;
            this.strideY = this.getWidth();
        }
    }

    public BufferedImage toBufferedImage() {
        BufferedImage b = new BufferedImage(this.getWidth(), this.getHeight(), this.getType());
        Graphics g = b.getGraphics();
        g.drawImage(this.bufferedImage, 0, 0, null);
        return b;
    }

    public Image toImage() {
        return Toolkit.getDefaultToolkit().createImage(this.bufferedImage.getSource());
    }

    public ImageIcon toIcon() {
        BufferedImage b = new BufferedImage(this.getWidth(), this.getHeight(), this.getType());
        Graphics g = b.getGraphics();
        g.drawImage(this.bufferedImage, 0, 0, null);
        ImageIcon ico = new ImageIcon(b);
        return ico;
    }

    public void toGrayscale() {
        new Grayscale().applyInPlace(this);
        this.pixels = null;
    }

    public void toARGB() {
        BufferedImage b = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics g = b.getGraphics();
        g.drawImage(this.bufferedImage, 0, 0, null);
        this.bufferedImage = b;
        this.refresh();
        g.dispose();
    }

    public void toRGB() {
        BufferedImage b = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics g = b.getGraphics();
        g.drawImage(this.bufferedImage, 0, 0, null);
        this.bufferedImage = b;
        this.refresh();
        g.dispose();
    }

    public double[] toArrayGrayAsDouble() {
        double[] array = new double[this.getHeight() * this.getWidth()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getGray(i);
        }
        return array;
    }

    public int[] toArrayGrayAsInt() {
        int[] array = new int[this.getHeight() * this.getWidth()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getGray(i);
        }
        return array;
    }

    public float[] toArrayGrayAsFloat() {
        float[] array = new float[this.getHeight() * this.getWidth()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getGray(i);
        }
        return array;
    }

    public int[][] toMatrixGrayAsInt() {
        int height = this.getHeight();
        int width = this.getWidth();
        int[][] image = new int[height][width];
        int idx = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                image[i][j] = this.getGray(idx++);
            }
        }
        return image;
    }

    public double[][] toMatrixGrayAsDouble() {
        int height = this.getHeight();
        int width = this.getWidth();
        double[][] image = new double[height][width];
        int idx = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                image[i][j] = this.getGray(idx++);
            }
        }
        return image;
    }

    public float[][] toMatrixGrayAsFloat() {
        int height = this.getHeight();
        int width = this.getWidth();
        float[][] image = new float[height][width];
        int idx = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                image[i][j] = this.getGray(idx++);
            }
        }
        return image;
    }

    public int[][][] toMatrixRGBAsInt() {
        int height = this.getHeight();
        int width = this.getWidth();
        int[][][] image = new int[height][width][3];
        int idx = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                image[i][j][0] = this.getRed(idx);
                image[i][j][1] = this.getGreen(idx);
                image[i][j][2] = this.getBlue(idx);
                ++idx;
            }
        }
        return image;
    }

    public double[][][] toMatrixRGBAsDouble() {
        int height = this.getHeight();
        int width = this.getWidth();
        double[][][] image = new double[height][width][3];
        int idx = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                image[i][j][0] = this.getRed(idx);
                image[i][j][1] = this.getGreen(idx);
                image[i][j][2] = this.getBlue(idx);
                ++idx;
            }
        }
        return image;
    }

    public float[][][] toMatrixRGBAsFloat() {
        int height = this.getHeight();
        int width = this.getWidth();
        float[][][] image = new float[height][width][3];
        int idx = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                image[i][j][0] = this.getRed(idx);
                image[i][j][1] = this.getGreen(idx);
                image[i][j][2] = this.getBlue(idx);
                ++idx;
            }
        }
        return image;
    }

    public void matrixToImage(int[][] image) {
        int idx = 0;
        for (int x = 0; x < image.length; ++x) {
            for (int y = 0; y < image[0].length; ++y) {
                this.setGray(idx++, image[x][y]);
            }
        }
    }

    public void matrixToImage(float[][] image) {
        int idx = 0;
        for (int x = 0; x < image.length; ++x) {
            for (int y = 0; y < image[0].length; ++y) {
                this.setGray(idx++, (int)image[x][y]);
            }
        }
    }

    public void matrixToImage(double[][] image) {
        int idx = 0;
        for (int x = 0; x < image.length; ++x) {
            for (int y = 0; y < image[0].length; ++y) {
                this.setGray(idx++, (int)image[x][y]);
            }
        }
    }

    public void matrixToImage(int[][][] image) {
        int idx = 0;
        if (image[0][0].length == 3) {
            for (int x = 0; x < image.length; ++x) {
                for (int y = 0; y < image[0].length; ++y) {
                    this.setRGB(idx++, image[x][y][0], image[x][y][1], image[x][y][2]);
                }
            }
        } else {
            for (int x = 0; x < image.length; ++x) {
                for (int y = 0; y < image[0].length; ++y) {
                    this.setARGB(idx++, image[x][y][0], image[x][y][1], image[x][y][2], image[x][y][3]);
                }
            }
        }
    }

    public void matrixToImage(float[][][] image) {
        int idx = 0;
        if (image[0][0].length == 3) {
            for (int x = 0; x < image.length; ++x) {
                for (int y = 0; y < image[0].length; ++y) {
                    this.setRGB(idx++, (int)image[x][y][0], (int)image[x][y][1], (int)image[x][y][2]);
                }
            }
        } else {
            for (int x = 0; x < image.length; ++x) {
                for (int y = 0; y < image[0].length; ++y) {
                    this.setARGB(idx++, (int)image[x][y][0], (int)image[x][y][1], (int)image[x][y][2], (int)image[x][y][3]);
                }
            }
        }
    }

    public void matrixToImage(double[][][] image) {
        int idx = 0;
        if (image[0][0].length == 3) {
            for (int x = 0; x < image.length; ++x) {
                for (int y = 0; y < image[0].length; ++y) {
                    this.setRGB(idx++, (int)image[x][y][0], (int)image[x][y][1], (int)image[x][y][2]);
                }
            }
        } else {
            for (int x = 0; x < image.length; ++x) {
                for (int y = 0; y < image[0].length; ++y) {
                    this.setARGB(idx++, (int)image[x][y][0], (int)image[x][y][1], (int)image[x][y][2], (int)image[x][y][3]);
                }
            }
        }
    }

    public void Clear() {
        if (this.isGrayscale()) {
            int size = this.pixelsGRAY.length;
            for (int i = 0; i < size; ++i) {
                this.pixelsGRAY[i] = 0;
            }
        } else {
            int size = this.pixels.length;
            for (int i = 0; i < size; ++i) {
                this.pixels[i] = 0;
            }
        }
    }

    public Graphics getGraphics() {
        return this.bufferedImage.getGraphics();
    }

    public void createGraphics() {
        this.bufferedImage.createGraphics();
    }

    private WritableRaster getRaster() {
        return this.bufferedImage.getRaster();
    }

    private int getType() {
        return this.bufferedImage.getType();
    }

    public boolean isGrayscale() {
        return this.bufferedImage.getType() == 10;
    }

    public boolean isRGB() {
        return this.bufferedImage.getType() == 1;
    }

    public boolean isARGB() {
        return this.bufferedImage.getType() == 2;
    }

    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    public int[] getRGB(int offset) {
        int[] rgb = new int[]{this.pixels[offset] >> 16 & 0xFF, this.pixels[offset] >> 8 & 0xFF, this.pixels[offset] & 0xFF};
        return rgb;
    }

    public int[] getRGB(int x, int y) {
        int[] rgb = new int[]{this.pixels[x * this.strideX + y * this.strideY] >> 16 & 0xFF, this.pixels[x * this.strideX + y * this.strideY] >> 8 & 0xFF, this.pixels[x * this.strideX + y * this.strideY] & 0xFF};
        return rgb;
    }

    public int[] getRGB(IntPoint point) {
        return this.getRGB(point.x, point.y);
    }

    public int getPackedRGB(int offset) {
        return this.pixels[offset];
    }

    public int getPackedRGB(int x, int y) {
        return this.pixels[x * this.strideX + y * this.strideY];
    }

    public int getPackedRGB(IntPoint point) {
        return this.pixels[point.x * this.strideX + point.y * this.strideY];
    }

    public int[] getARGB(int x, int y) {
        int[] argb = new int[]{this.pixels[x * this.strideX + y * this.strideY] >> 24 & 0xFF, this.pixels[x * this.strideX + y * this.strideY] >> 16 & 0xFF, this.pixels[x * this.strideX + y * this.strideY] >> 8 & 0xFF, this.pixels[x * this.strideX + y * this.strideY] & 0xFF};
        return argb;
    }

    public int[] getARGB(IntPoint point) {
        return this.getARGB(point.x, point.y);
    }

    public void setRGB(int x, int y, Color color) {
        this.setRGB(x, y, color.r, color.g, color.b);
    }

    public void setRGB(int x, int y, int red, int green, int blue) {
        int a = this.pixels[x * this.strideX + y * this.strideY] >> 24 & 0xFF;
        this.pixels[x * this.strideX + y * this.strideY] = a << 24 | red << 16 | green << 8 | blue;
    }

    public void setRGB(IntPoint point, Color color) {
        this.setRGB(point.x, point.y, color.r, color.g, color.b);
    }

    public void setRGB(IntPoint point, int red, int green, int blue) {
        this.setRGB(point.x, point.y, red, green, blue);
    }

    public void setRGB(int x, int y, int[] rgb) {
        this.pixels[x * this.strideX + y * this.strideY] = rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    public void setRGB(int offset, int red, int green, int blue) {
        int a = this.pixels[offset] >> 24 & 0xFF;
        this.pixels[offset] = a << 24 | red << 16 | green << 8 | blue;
    }

    public void setRGB(int offset, int[] rgb) {
        int a = this.pixels[offset] >> 24 & 0xFF;
        this.pixels[offset] = a << 24 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    public void setRGB(int offset, Color color) {
        int a = this.pixels[offset] >> 24 & 0xFF;
        this.pixels[offset] = a << 24 | color.r << 16 | color.g << 8 | color.b;
    }

    public void setRGB(IntPoint point, int[] rgb) {
        this.pixels[point.x * this.strideX + point.y * this.strideY] = rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    public void setRGB(int offset, int color) {
        this.pixels[offset] = color;
    }

    public void setRGB(int x, int y, int color) {
        this.pixels[x * this.strideX + y * this.strideY] = color;
    }

    public void setRGB(IntPoint point, int color) {
        this.pixels[point.x * this.strideX + point.y * this.strideY] = color;
    }

    public void setARGB(int x, int y, int alpha, int red, int green, int blue) {
        this.pixels[x * this.strideX + y * this.strideY] = alpha << 24 | red << 16 | green << 8 | blue;
    }

    public void setARGB(IntPoint point, int alpha, int red, int green, int blue) {
        this.setARGB(point.x, point.y, alpha, red, green, blue);
    }

    public void setARGB(int x, int y, int[] rgb) {
        this.pixels[x * this.strideX + y * this.strideY] = rgb[0] << 24 | rgb[1] << 16 | rgb[2] << 8 | rgb[3];
    }

    public void setARGB(IntPoint point, int[] rgb) {
        this.pixels[point.x * this.getWidth() + point.y] = rgb[0] << 24 | rgb[1] << 16 | rgb[2] << 8 | rgb[3];
    }

    public void setARGB(int offset, int alpha, int red, int green, int blue) {
        this.pixels[offset] = alpha << 24 | red << 16 | green << 8 | blue;
    }

    public void setARGB(int offset, int[] argb) {
        this.pixels[offset] = argb[0] << 24 | argb[1] << 16 | argb[2] << 8 | argb[3];
    }

    public int getGray(int x, int y) {
        return this.pixelsGRAY[x * this.strideX + y * this.strideY] & 0xFF;
    }

    public int getGray(IntPoint point) {
        return this.pixelsGRAY[point.x * this.getWidth() + point.y] & 0xFF;
    }

    public int getGray(int offset) {
        return this.pixelsGRAY[offset] & 0xFF;
    }

    public void setGray(int offset, int value) {
        this.pixelsGRAY[offset] = (byte)value;
    }

    public void setGray(int x, int y, int value) {
        this.pixelsGRAY[x * this.strideX + y * this.strideY] = (byte)value;
    }

    public void setGray(IntPoint point, int value) {
        this.pixelsGRAY[point.x * this.strideX + point.y * this.strideY] = (byte)value;
    }

    public int getAlpha(int x, int y) {
        return this.pixels[x * this.strideX + y * this.strideY] >> 24 & 0xFF;
    }

    public int getAlpha(int offset) {
        return this.pixels[offset] >> 24 & 0xFF;
    }

    public void setAlpha(int offset, int value) {
        this.pixels[offset] = this.pixels[offset] & 0xFFFFFF | value << 24;
    }

    public void setAlpha(int x, int y, int value) {
        this.pixels[x * this.strideX + y * this.strideY] = this.pixels[x * this.strideX + y * this.strideY] & 0xFFFFFF | value << 24;
    }

    public int getRed(int x, int y) {
        return this.pixels[x * this.strideX + y * this.strideY] >> 16 & 0xFF;
    }

    public int getRed(IntPoint point) {
        return this.getRed(point.x, point.y);
    }

    public int getRed(int offset) {
        return this.pixels[offset] >> 16 & 0xFF;
    }

    public void setRed(int offset, int value) {
        this.pixels[offset] = this.pixels[offset] & 0xFF00FFFF | value << 16;
    }

    public void setRed(int x, int y, int value) {
        this.pixels[x * this.strideX + y * this.strideY] = this.pixels[x * this.strideX + y * this.strideY] & 0xFF00FFFF | value << 16;
    }

    public void setRed(IntPoint point, int value) {
        this.setRed(point.x, point.y, value);
    }

    public int getGreen(int x, int y) {
        return this.pixels[x * this.strideX + y * this.strideY] >> 8 & 0xFF;
    }

    public int getGreen(IntPoint point) {
        return this.getGreen(point.x, point.y);
    }

    public int getGreen(int offset) {
        return this.pixels[offset] >> 8 & 0xFF;
    }

    public void setGreen(int offset, int value) {
        this.pixels[offset] = this.pixels[offset] & 0xFFFF00FF | value << 8;
    }

    public void setGreen(int x, int y, int value) {
        this.pixels[x * this.strideX + y * this.strideY] = this.pixels[x * this.strideX + y * this.strideY] & 0xFFFF00FF | value << 8;
    }

    public void setGreen(IntPoint point, int value) {
        this.setGreen(point.x, point.y, value);
    }

    public int getBlue(int x, int y) {
        return this.pixels[x * this.strideX + y * this.strideY] & 0xFF;
    }

    public int getBlue(IntPoint point) {
        return this.getBlue(point.x, point.y);
    }

    public int getBlue(int offset) {
        return this.pixels[offset] & 0xFF;
    }

    public void setBlue(int offset, int value) {
        this.pixels[offset] = this.pixels[offset] & 0xFFFFFF00 | value;
    }

    public void setBlue(int x, int y, int value) {
        this.pixels[x * this.strideX + y * this.strideY] = this.pixels[x * this.strideX + y * this.strideY] & 0xFFFFFF00 | value;
    }

    public void setBlue(IntPoint point, int value) {
        this.setBlue(point.x, point.y, value);
    }

    public int clampValues(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 255) {
            return 255;
        }
        return value;
    }

    public int clampValues(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public void saveAsBMP(String pathname) {
        try {
            ImageIO.write((RenderedImage)this.bufferedImage, "bmp", new File(pathname));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void saveAsPNG(String pathname) {
        try {
            ImageIO.write((RenderedImage)this.bufferedImage, "png", new File(pathname));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void saveAsGIF(String pathname) {
        try {
            ImageIO.write((RenderedImage)this.bufferedImage, "gif", new File(pathname));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void saveAsJPG(String pathname, float quality) {
        try {
            JPEGImageWriteParam params = new JPEGImageWriteParam(null);
            params.setCompressionMode(2);
            params.setCompressionQuality(quality);
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
            writer.setOutput(new FileImageOutputStream(new File(pathname)));
            writer.write(null, new IIOImage(this.bufferedImage, null, null), params);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void saveAsJPG(String pathname, float quality, int xDpi, int yDpi) {
        try {
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
            IIOMetadata imageMetaData = writer.getDefaultImageMetadata(new ImageTypeSpecifier(this.bufferedImage), null);
            Element tree = (Element)imageMetaData.getAsTree("javax_imageio_jpeg_image_1.0");
            Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
            jfif.setAttribute("Xdensity", Integer.toString(xDpi));
            jfif.setAttribute("Ydensity", Integer.toString(yDpi));
            jfif.setAttribute("resUnits", "1");
            imageMetaData.setFromTree("javax_imageio_jpeg_image_1.0", tree);
            JPEGImageWriteParam params = new JPEGImageWriteParam(null);
            params.setCompressionMode(2);
            params.setCompressionQuality(quality);
            writer.setOutput(new FileImageOutputStream(new File(pathname)));
            writer.write(imageMetaData, new IIOImage(this.bufferedImage, null, imageMetaData), params);
            writer.dispose();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void saveAsJPG(String pathname) {
        try {
            ImageIO.write((RenderedImage)this.bufferedImage, "jpg", new File(pathname));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static enum ColorSpace {
        Grayscale,
        RGB,
        ARGB;

    }

    public static enum CoordinateSystem {
        Cartesian,
        Matrix;

    }
}

