/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Corners.FREAK;

import java.util.ArrayList;

public class FastRetinaKeypointPattern {
    public static final int Scales = 64;
    public static final int Orientations = 256;
    public static final int Points = 43;
    public static final int Size = 7;
    private int octaves;
    private float scale;
    public PatternPoint[] lookupTable;
    public double step;
    public int[] patternSizes = new int[64];
    public int[] pointsValues = new int[43];
    public DescriptionPair[] descriptionPairs = new DescriptionPair[512];
    public OrientationPair[] orientationPairs = new OrientationPair[45];
    static int[] CV_FREAK_DEF_PAIRS = new int[]{404, 431, 818, 511, 181, 52, 311, 874, 774, 543, 719, 230, 417, 205, 11, 560, 149, 265, 39, 306, 165, 857, 250, 8, 61, 15, 55, 717, 44, 412, 592, 134, 761, 695, 660, 782, 625, 487, 549, 516, 271, 665, 762, 392, 178, 796, 773, 31, 672, 845, 548, 794, 677, 654, 241, 831, 225, 238, 849, 83, 691, 484, 826, 707, 122, 517, 583, 731, 328, 339, 571, 475, 394, 472, 580, 381, 137, 93, 380, 327, 619, 729, 808, 218, 213, 459, 141, 806, 341, 95, 382, 568, 124, 750, 193, 749, 706, 843, 79, 199, 317, 329, 768, 198, 100, 466, 613, 78, 562, 783, 689, 136, 838, 94, 142, 164, 679, 219, 419, 366, 418, 423, 77, 89, 523, 259, 683, 312, 555, 20, 470, 684, 123, 458, 453, 833, 72, 113, 253, 108, 313, 25, 153, 648, 411, 607, 618, 128, 305, 232, 301, 84, 56, 264, 371, 46, 407, 360, 38, 99, 176, 710, 114, 578, 66, 372, 653, 129, 359, 424, 159, 821, 10, 323, 393, 5, 340, 891, 9, 790, 47, 0, 175, 346, 236, 26, 172, 147, 574, 561, 32, 294, 429, 724, 755, 398, 787, 288, 299, 769, 565, 767, 722, 757, 224, 465, 723, 498, 467, 235, 127, 802, 446, 233, 544, 482, 800, 318, 16, 532, 801, 441, 554, 173, 60, 530, 713, 469, 30, 212, 630, 899, 170, 266, 799, 88, 49, 512, 399, 23, 500, 107, 524, 90, 194, 143, 135, 192, 206, 345, 148, 71, 119, 101, 563, 870, 158, 254, 214, 276, 464, 332, 725, 188, 385, 24, 476, 40, 231, 620, 171, 258, 67, 109, 844, 244, 187, 388, 701, 690, 50, 7, 850, 479, 48, 522, 22, 154, 12, 659, 736, 655, 577, 737, 830, 811, 174, 21, 237, 335, 353, 234, 53, 270, 62, 182, 45, 177, 245, 812, 673, 355, 556, 612, 166, 204, 54, 248, 365, 226, 242, 452, 700, 685, 573, 14, 842, 481, 468, 781, 564, 416, 179, 405, 35, 819, 608, 624, 367, 98, 643, 448, 2, 460, 676, 440, 240, 130, 146, 184, 185, 430, 65, 807, 377, 82, 121, 708, 239, 310, 138, 596, 730, 575, 477, 851, 797, 247, 27, 85, 586, 307, 779, 326, 494, 856, 324, 827, 96, 748, 13, 397, 125, 688, 702, 92, 293, 716, 277, 140, 112, 4, 80, 855, 839, 1, 413, 347, 584, 493, 289, 696, 19, 751, 379, 76, 73, 115, 6, 590, 183, 734, 197, 483, 217, 344, 330, 400, 186, 243, 587, 220, 780, 200, 793, 246, 824, 41, 735, 579, 81, 703, 322, 760, 720, 139, 480, 490, 91, 814, 813, 163, 152, 488, 763, 263, 425, 410, 576, 120, 319, 668, 150, 160, 302, 491, 515, 260, 145, 428, 97, 251, 395, 272, 252, 18, 106, 358, 854, 485, 144, 550, 131, 133, 378, 68, 102, 104, 58, 361, 275, 209, 697, 582, 338, 742, 589, 325, 408, 229, 28, 304, 191, 189, 110, 126, 486, 211, 547, 533, 70, 215, 670, 249, 36, 581, 389, 605, 331, 518, 442, 822};

    public int getOctaves() {
        return this.octaves;
    }

    public float getScale() {
        return this.scale;
    }

    public FastRetinaKeypointPattern(int octaves, float scales) {
        int i;
        this.octaves = octaves;
        this.scale = scales;
        this.lookupTable = new PatternPoint[704512];
        double scaleStep = Math.pow(2.0, (double)octaves / 64.0);
        this.step = (float)(64.0 / (0.6931471805599453 * (double)octaves));
        int[] n = new int[]{6, 6, 6, 6, 6, 6, 6, 1};
        double bigR = 0.6666666666666666;
        double smallR = 0.08333333333333333;
        double unitSpace = (bigR - smallR) / 21.0;
        double[] radius = new double[]{bigR, bigR - 6.0 * unitSpace, bigR - 11.0 * unitSpace, bigR - 15.0 * unitSpace, bigR - 18.0 * unitSpace, bigR - 20.0 * unitSpace, smallR, 0.0};
        double[] sigma = new double[]{radius[0] / 2.0, radius[1] / 2.0, radius[2] / 2.0, radius[3] / 2.0, radius[4] / 2.0, radius[5] / 2.0, radius[6] / 2.0, radius[6] / 2.0};
        for (int scaleIdx = 0; scaleIdx < 64; ++scaleIdx) {
            this.patternSizes[scaleIdx] = 0;
            double scalingFactor = Math.pow(scaleStep, scaleIdx);
            for (int orientationIdx = 0; orientationIdx < 256; ++orientationIdx) {
                double theta = (double)(orientationIdx * 2) * Math.PI / 256.0;
                int pointIdx = 0;
                for (int i2 = 0; i2 < 8; ++i2) {
                    for (int k = 0; k < n[i2]; ++k) {
                        PatternPoint point;
                        double beta = Math.PI / (double)n[i2] * (double)(i2 % 2);
                        double alpha = (double)(k * 2) * Math.PI / (double)n[i2] + beta + theta;
                        this.lookupTable[scaleIdx * 256 * 43 + orientationIdx * 43 + pointIdx] = point = new PatternPoint((float)(radius[i2] * Math.cos(alpha) * scalingFactor * (double)this.scale), (float)(radius[i2] * Math.sin(alpha) * scalingFactor * (double)this.scale), (float)(sigma[i2] * scalingFactor * (double)this.scale));
                        int sizeMax = (int)Math.ceil((radius[i2] + sigma[i2]) * scalingFactor * (double)this.scale) + 1;
                        if (this.patternSizes[scaleIdx] < sizeMax) {
                            this.patternSizes[scaleIdx] = sizeMax;
                        }
                        ++pointIdx;
                    }
                }
            }
        }
        for (int i3 = 0; i3 < 45; ++i3) {
            this.orientationPairs[i3] = new OrientationPair();
        }
        this.orientationPairs[0].i = 0;
        this.orientationPairs[0].j = 3;
        this.orientationPairs[1].i = 1;
        this.orientationPairs[1].j = 4;
        this.orientationPairs[2].i = 2;
        this.orientationPairs[2].j = 5;
        this.orientationPairs[3].i = 0;
        this.orientationPairs[3].j = 2;
        this.orientationPairs[4].i = 1;
        this.orientationPairs[4].j = 3;
        this.orientationPairs[5].i = 2;
        this.orientationPairs[5].j = 4;
        this.orientationPairs[6].i = 3;
        this.orientationPairs[6].j = 5;
        this.orientationPairs[7].i = 4;
        this.orientationPairs[7].j = 0;
        this.orientationPairs[8].i = 5;
        this.orientationPairs[8].j = 1;
        this.orientationPairs[9].i = 6;
        this.orientationPairs[9].j = 9;
        this.orientationPairs[10].i = 7;
        this.orientationPairs[10].j = 10;
        this.orientationPairs[11].i = 8;
        this.orientationPairs[11].j = 11;
        this.orientationPairs[12].i = 6;
        this.orientationPairs[12].j = 8;
        this.orientationPairs[13].i = 7;
        this.orientationPairs[13].j = 9;
        this.orientationPairs[14].i = 8;
        this.orientationPairs[14].j = 10;
        this.orientationPairs[15].i = 9;
        this.orientationPairs[15].j = 11;
        this.orientationPairs[16].i = 10;
        this.orientationPairs[16].j = 6;
        this.orientationPairs[17].i = 11;
        this.orientationPairs[17].j = 7;
        this.orientationPairs[18].i = 12;
        this.orientationPairs[18].j = 15;
        this.orientationPairs[19].i = 13;
        this.orientationPairs[19].j = 16;
        this.orientationPairs[20].i = 14;
        this.orientationPairs[20].j = 17;
        this.orientationPairs[21].i = 12;
        this.orientationPairs[21].j = 14;
        this.orientationPairs[22].i = 13;
        this.orientationPairs[22].j = 15;
        this.orientationPairs[23].i = 14;
        this.orientationPairs[23].j = 16;
        this.orientationPairs[24].i = 15;
        this.orientationPairs[24].j = 17;
        this.orientationPairs[25].i = 16;
        this.orientationPairs[25].j = 12;
        this.orientationPairs[26].i = 17;
        this.orientationPairs[26].j = 13;
        this.orientationPairs[27].i = 18;
        this.orientationPairs[27].j = 21;
        this.orientationPairs[28].i = 19;
        this.orientationPairs[28].j = 22;
        this.orientationPairs[29].i = 20;
        this.orientationPairs[29].j = 23;
        this.orientationPairs[30].i = 18;
        this.orientationPairs[30].j = 20;
        this.orientationPairs[31].i = 19;
        this.orientationPairs[31].j = 21;
        this.orientationPairs[32].i = 20;
        this.orientationPairs[32].j = 22;
        this.orientationPairs[33].i = 21;
        this.orientationPairs[33].j = 23;
        this.orientationPairs[34].i = 22;
        this.orientationPairs[34].j = 18;
        this.orientationPairs[35].i = 23;
        this.orientationPairs[35].j = 19;
        this.orientationPairs[36].i = 24;
        this.orientationPairs[36].j = 27;
        this.orientationPairs[37].i = 25;
        this.orientationPairs[37].j = 28;
        this.orientationPairs[38].i = 26;
        this.orientationPairs[38].j = 29;
        this.orientationPairs[39].i = 30;
        this.orientationPairs[39].j = 33;
        this.orientationPairs[40].i = 31;
        this.orientationPairs[40].j = 34;
        this.orientationPairs[41].i = 32;
        this.orientationPairs[41].j = 35;
        this.orientationPairs[42].i = 36;
        this.orientationPairs[42].j = 39;
        this.orientationPairs[43].i = 37;
        this.orientationPairs[43].j = 40;
        this.orientationPairs[44].i = 38;
        this.orientationPairs[44].j = 41;
        for (int m = 0; m < this.orientationPairs.length; ++m) {
            float dx = this.lookupTable[this.orientationPairs[m].i].x - this.lookupTable[this.orientationPairs[m].j].x;
            float dy = this.lookupTable[this.orientationPairs[m].i].y - this.lookupTable[this.orientationPairs[m].j].y;
            float norm_sq = dx * dx + dy * dy;
            this.orientationPairs[m].weight_dx = (int)((double)(dx / norm_sq) * 4096.0 + 0.5);
            this.orientationPairs[m].weight_dy = (int)((double)(dy / norm_sq) * 4096.0 + 0.5);
        }
        ArrayList<DescriptionPair> allPairs = new ArrayList<DescriptionPair>();
        for (i = 1; i < 43; ++i) {
            for (int j = 0; j < i; ++j) {
                allPairs.add(new DescriptionPair(i, j));
            }
        }
        for (i = 0; i < 512; ++i) {
            this.descriptionPairs[i] = new DescriptionPair(0, 0);
        }
        for (i = 0; i < this.descriptionPairs.length; ++i) {
            this.descriptionPairs[i] = (DescriptionPair)allPairs.get(CV_FREAK_DEF_PAIRS[i]);
        }
    }

    class OrientationPair {
        public int i = 0;
        public int j = 0;
        public int weight_dx;
        public int weight_dy;
    }

    class DescriptionPair {
        public int i;
        public int j;

        public DescriptionPair(int i, int j) {
            this.i = i;
            this.j = j;
        }
    }

    class PatternPoint {
        public float x;
        public float y;
        public float sigma;

        public PatternPoint(float x, float y, float sigma) {
            this.x = x;
            this.y = y;
            this.sigma = sigma;
        }
    }
}

