/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Corners.FREAK;

import Catalano.Imaging.Corners.FREAK.FastRetinaKeypoint;
import Catalano.Imaging.Corners.FREAK.FastRetinaKeypointPattern;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.IntegralImage;
import java.util.ArrayList;
import java.util.List;

public class FastRetinaKeypointDescriptor {
    private FastRetinaKeypointPattern pattern;
    private boolean isOrientationNormal = true;
    private boolean isScaleNormal = true;
    private boolean isExtended = false;
    private FastBitmap Image;
    public IntegralImage Integral;
    FastRetinaKeypoint temp;

    public boolean IsOrientationNormal() {
        return this.isOrientationNormal;
    }

    public void setOrientationNormal(boolean isOrientationNormal) {
        this.isOrientationNormal = isOrientationNormal;
    }

    public boolean IsScaleNormal() {
        return this.isScaleNormal;
    }

    public void setScaleNormal(boolean isScaleNormal) {
        this.isScaleNormal = isScaleNormal;
    }

    public boolean IsExtended() {
        return this.isExtended;
    }

    public void setExtended(boolean isExtended) {
        this.isExtended = isExtended;
    }

    FastRetinaKeypointDescriptor(FastBitmap fastBitmap, IntegralImage integral, FastRetinaKeypointPattern pattern) {
        this.Image = fastBitmap;
        this.Integral = integral;
        this.pattern = pattern;
    }

    public void Compute(List<FastRetinaKeypoint> points) {
        int k;
        int CV_FREAK_SMALLEST_KP_SIZE = 7;
        int CV_FREAK_NB_SCALES = 64;
        int CV_FREAK_NB_ORIENTATION = 256;
        int[] patternSizes = this.pattern.patternSizes;
        int[] pointsValues = this.pattern.pointsValues;
        FastRetinaKeypointPattern.OrientationPair[] orientationPairs = this.pattern.orientationPairs;
        FastRetinaKeypointPattern.DescriptionPair[] descriptionPairs = this.pattern.descriptionPairs;
        double step = this.pattern.step;
        ArrayList<Integer> scaleIndex = new ArrayList<Integer>(points.size());
        for (int i = 0; i < points.size(); ++i) {
            scaleIndex.add(0);
        }
        if (this.isScaleNormal) {
            for (k = points.size() - 1; k >= 0; --k) {
                double ratio = points.get((int)k).scale / 7.0;
                scaleIndex.set(k, Math.max((int)(Math.log(ratio) * step + 0.5), 0));
                if ((Integer)scaleIndex.get(k) >= 64) {
                    scaleIndex.set(k, 63);
                }
                if (!(points.get((int)k).x <= (double)patternSizes[(Integer)scaleIndex.get(k)] || points.get((int)k).y <= (double)patternSizes[(Integer)scaleIndex.get(k)] || points.get((int)k).x >= (double)(this.Image.getHeight() - patternSizes[(Integer)scaleIndex.get(k)])) && !(points.get((int)k).y >= (double)(this.Image.getWidth() - patternSizes[(Integer)scaleIndex.get(k)]))) continue;
                points.remove(k);
                scaleIndex.remove(k);
            }
        } else {
            int scale = Math.max((int)(1.0986122886681098 * step + 0.5), 0);
            for (int k2 = points.size() - 1; k2 >= 0; --k2) {
                scaleIndex.set(k2, scale);
                if ((Integer)scaleIndex.get(k2) >= 64) {
                    scaleIndex.set(k2, 63);
                }
                if (!(points.get((int)k2).x <= (double)patternSizes[(Integer)scaleIndex.get(k2)] || points.get((int)k2).y <= (double)patternSizes[(Integer)scaleIndex.get(k2)] || points.get((int)k2).x >= (double)(this.Image.getHeight() - patternSizes[(Integer)scaleIndex.get(k2)])) && !(points.get((int)k2).y >= (double)(this.Image.getWidth() - patternSizes[(Integer)scaleIndex.get(k2)]))) continue;
                points.remove(k2);
                scaleIndex.remove(k2);
            }
        }
        for (k = 0; k < points.size(); ++k) {
            int i;
            int thetaIndex = 0;
            if (!this.isOrientationNormal) {
                this.temp = points.get(k);
                this.temp.setOrientation(0.0);
                thetaIndex = 0;
                points.set(k, this.temp);
            } else {
                for (i = 0; i < pointsValues.length; ++i) {
                    pointsValues[i] = this.mean(points.get((int)k).x, points.get((int)k).y, (Integer)scaleIndex.get(k), 0, i);
                }
                int a = 0;
                int b = 0;
                for (int m = 0; m < orientationPairs.length; ++m) {
                    FastRetinaKeypointPattern.OrientationPair p = orientationPairs[m];
                    int delta = pointsValues[p.i] - pointsValues[p.j];
                    a += delta * p.weight_dx / 2048;
                    b += delta * p.weight_dy / 2048;
                }
                this.temp = points.get(k);
                this.temp.setOrientation(Math.atan2(b, a) * 57.29577951308232);
                points.set(k, this.temp);
                thetaIndex = (int)(256.0 * points.get(k).getOrientation() * 0.002777777777777778 + 0.5);
                if (thetaIndex < 0) {
                    thetaIndex += 256;
                }
                if (thetaIndex >= 256) {
                    thetaIndex -= 256;
                }
            }
            for (i = 0; i < pointsValues.length; ++i) {
                pointsValues[i] = this.mean(points.get((int)k).x, points.get((int)k).y, (Integer)scaleIndex.get(k), thetaIndex, i);
            }
            if (!this.isExtended) {
                this.temp = points.get(k);
                this.temp.setDescriptor(new byte[64]);
                for (int m = 0; m < descriptionPairs.length; ++m) {
                    FastRetinaKeypointPattern.DescriptionPair p = descriptionPairs[m];
                    byte[] descriptor = this.temp.getDescriptor();
                    if (pointsValues[p.i] > pointsValues[p.j]) {
                        int n = m / 8;
                        descriptor[n] = (byte)(descriptor[n] | (byte)(1 << m % 8));
                        continue;
                    }
                    int n = m / 8;
                    descriptor[n] = (byte)(descriptor[n] & (byte)(~(1 << m % 8)));
                }
                continue;
            }
            this.temp = points.get(k);
            this.temp.setDescriptor(new byte[128]);
            int m = 0;
            for (i = 1; i < pointsValues.length; ++i) {
                int j = 0;
                while (j < i) {
                    byte[] descriptor = this.temp.getDescriptor();
                    if (pointsValues[i] > pointsValues[j]) {
                        int n = m / 8;
                        descriptor[n] = (byte)(descriptor[n] | (byte)(1 << m % 8));
                    } else {
                        int n = m / 8;
                        descriptor[n] = (byte)(descriptor[n] & (byte)(~(1 << m % 8)));
                    }
                    ++j;
                    ++m;
                }
            }
        }
    }

    private int mean(double kx, double ky, int scale, int orientation, int pointIndex) {
        int CV_FREAK_NB_ORIENTATION = 256;
        int CV_FREAK_NB_POINTS = 43;
        FastRetinaKeypointPattern.PatternPoint freak = this.pattern.lookupTable[scale * 256 * 43 + orientation * 43 + pointIndex];
        double xf = (double)freak.x + ky;
        double yf = (double)freak.y + kx;
        int x = (int)xf;
        int y = (int)yf;
        float radius = freak.sigma;
        if ((double)radius < 0.5) {
            int r_x = (int)((xf - (double)x) * 1024.0);
            int r_y = (int)((yf - (double)y) * 1024.0);
            int r_x_1 = 1024 - r_x;
            int r_y_1 = 1024 - r_y;
            int ret_val = r_x_1 * r_y_1 * this.Image.getGray(y, x);
            ret_val += r_x * r_y_1 * this.Image.getGray(y, x + 1);
            ret_val += r_x * r_y * this.Image.getGray(y + 1, x + 1);
            return ((ret_val += r_x_1 * r_y * this.Image.getGray(y + 1, x)) + 512) / 1024;
        }
        int x_left = (int)(xf - (double)radius + 0.5);
        int y_top = (int)(yf - (double)radius + 0.5);
        int x_right = (int)(xf + (double)radius + 1.5);
        int y_bottom = (int)(yf + (double)radius + 1.5);
        int ret_val = this.Integral.getInternalData(y_bottom, x_right);
        ret_val -= this.Integral.getInternalData(y_bottom, x_left);
        ret_val += this.Integral.getInternalData(y_top, x_left);
        ret_val -= this.Integral.getInternalData(y_top, x_right);
        return ret_val /= (x_right - x_left) * (y_bottom - y_top);
    }
}

