/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Core.FloatRange;
import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ColorConverter;

public class YCbCrFiltering
implements IApplyInPlace {
    private FloatRange yRange = new FloatRange(0.0f, 1.0f);
    private FloatRange cbRange = new FloatRange(-0.5f, 0.5f);
    private FloatRange crRange = new FloatRange(-0.5f, 0.5f);
    private float fillY = 0.0f;
    private float fillCb = 0.0f;
    private float fillCr = 0.0f;
    private boolean fillOutsideRange = true;
    private boolean updateY = true;
    private boolean updateCb = true;
    private boolean updateCr = true;

    public FloatRange getY() {
        return this.yRange;
    }

    public void setHue(FloatRange y) {
        this.yRange = y;
    }

    public FloatRange getCb() {
        return this.cbRange;
    }

    public void setCb(FloatRange cb) {
        this.cbRange = cb;
    }

    public FloatRange getCr() {
        return this.crRange;
    }

    public void setCr(FloatRange cr) {
        this.crRange = cr;
    }

    public float[] getFillColor() {
        return new float[]{this.fillY, this.fillCb, this.fillCr};
    }

    public void setFillColor(float y, float cb, float cr) {
        this.fillY = y;
        this.fillCb = cb;
        this.fillCr = cr;
    }

    public boolean isFillOutsideRange() {
        return this.fillOutsideRange;
    }

    public void setFillOutsideRange(boolean fillOutsideRange) {
        this.fillOutsideRange = fillOutsideRange;
    }

    public boolean isUpdatedY() {
        return this.updateY;
    }

    public void setUpdateY(boolean update) {
        this.updateY = update;
    }

    public boolean isUpdatedCb() {
        return this.updateCb;
    }

    public void setUpdateCb(boolean update) {
        this.updateCb = update;
    }

    public boolean isUpdatedCr() {
        return this.updateCr;
    }

    public void setUpdateCr(boolean update) {
        this.updateCr = update;
    }

    public YCbCrFiltering() {
    }

    public YCbCrFiltering(FloatRange y, FloatRange cb, FloatRange cr) {
        this.yRange = y;
        this.cbRange = cb;
        this.crRange = cr;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isRGB()) {
            throw new IllegalArgumentException("HSL Filtering only works in RGB space color.");
        }
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fastBitmap.getHeight() / cores;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                for (int j = 0; j < this.share.endWidth; ++j) {
                    int b;
                    int g;
                    boolean updated = false;
                    int r = this.share.fastBitmap.getRed(i, j);
                    double[] ycbcr = ColorConverter.RGBtoYCbCr(r, g = this.share.fastBitmap.getGreen(i, j), b = this.share.fastBitmap.getBlue(i, j), ColorConverter.YCbCrColorSpace.ITU_BT_601);
                    if (ycbcr[0] >= (double)YCbCrFiltering.this.yRange.getMin() && ycbcr[0] <= (double)YCbCrFiltering.this.yRange.getMax() && ycbcr[1] >= (double)YCbCrFiltering.this.cbRange.getMin() && ycbcr[1] <= (double)YCbCrFiltering.this.cbRange.getMax() && ycbcr[2] >= (double)YCbCrFiltering.this.crRange.getMin() && ycbcr[2] <= (double)YCbCrFiltering.this.crRange.getMax()) {
                        if (!YCbCrFiltering.this.fillOutsideRange) {
                            if (YCbCrFiltering.this.updateY) {
                                ycbcr[0] = YCbCrFiltering.this.fillY;
                            }
                            if (YCbCrFiltering.this.updateCb) {
                                ycbcr[1] = YCbCrFiltering.this.fillCb;
                            }
                            if (YCbCrFiltering.this.updateCr) {
                                ycbcr[2] = YCbCrFiltering.this.fillCr;
                            }
                            updated = true;
                        }
                    } else if (YCbCrFiltering.this.fillOutsideRange) {
                        if (YCbCrFiltering.this.updateY) {
                            ycbcr[0] = YCbCrFiltering.this.fillY;
                        }
                        if (YCbCrFiltering.this.updateCb) {
                            ycbcr[1] = YCbCrFiltering.this.fillCb;
                        }
                        if (YCbCrFiltering.this.updateCr) {
                            ycbcr[2] = YCbCrFiltering.this.fillCr;
                        }
                        updated = true;
                    }
                    if (!updated) continue;
                    int[] rgb = ColorConverter.YCbCrtoRGB(ycbcr[0], ycbcr[1], ycbcr[2], ColorConverter.YCbCrColorSpace.ITU_BT_601);
                    this.share.fastBitmap.setRGB(i, j, rgb);
                }
            }
        }
    }
}

