/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Minimum
implements IApplyInPlace {
    private int radius = 1;
    private FastBitmap copy;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public Minimum() {
    }

    public Minimum(int radius) {
        this.setRadius(radius);
    }

    @Override
    public void applyInPlace(FastBitmap fb) {
        int i;
        this.copy = new FastBitmap(fb);
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fb.getHeight() / cores;
        int last = cores - 1;
        boolean lastThread = false;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            if (i == last) {
                lastThread = true;
            }
            t[i] = new Thread(new CThread(new Share(fb, startX, startX += part, lastThread)));
            t[i].start();
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class CThread
    implements Runnable {
        private Share share;

        public CThread(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            int lines = this.CalcLines(Minimum.this.radius);
            int safe = Minimum.this.radius;
            if (this.share.lastThread) {
                safe = 0;
                this.share.endHeight = this.share.fastBitmap.getHeight();
            }
            if (this.share.fastBitmap.isGrayscale()) {
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int min = 255;
                        for (int i = 0; i < lines; ++i) {
                            int Xline = x + (i - Minimum.this.radius);
                            for (int j = 0; j < lines; ++j) {
                                int Yline = y + (j - Minimum.this.radius);
                                if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth() || Minimum.this.copy.getGray(Xline, Yline) >= min) continue;
                                min = Minimum.this.copy.getGray(Xline, Yline);
                            }
                        }
                        this.share.fastBitmap.setGray(x, y, min);
                    }
                }
            } else {
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int minB = 255;
                        int minG = 255;
                        int minR = 255;
                        for (int i = 0; i < lines; ++i) {
                            int Xline = x + (i - Minimum.this.radius);
                            for (int j = 0; j < lines; ++j) {
                                int Yline = y + (j - Minimum.this.radius);
                                if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth()) continue;
                                if (Minimum.this.copy.getRed(Xline, Yline) < minR) {
                                    minR = Minimum.this.copy.getRed(Xline, Yline);
                                }
                                if (Minimum.this.copy.getGreen(Xline, Yline) < minG) {
                                    minG = Minimum.this.copy.getGreen(Xline, Yline);
                                }
                                if (Minimum.this.copy.getBlue(Xline, Yline) >= minB) continue;
                                minB = Minimum.this.copy.getBlue(Xline, Yline);
                            }
                        }
                        this.share.fastBitmap.setRGB(x, y, minR, minG, minB);
                    }
                }
            }
        }

        private int CalcLines(int radius) {
            return radius * 2 + 1;
        }
    }
}

