/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import java.util.Arrays;

public class Median
implements IApplyInPlace {
    private int radius = 1;
    private FastBitmap copy;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public Median() {
    }

    public Median(int radius) {
        this.setRadius(radius);
    }

    @Override
    public void applyInPlace(FastBitmap fb) {
        int i;
        this.copy = new FastBitmap(fb);
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fb.getHeight() / cores;
        int last = cores - 1;
        boolean lastThread = false;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            if (i == last) {
                lastThread = true;
            }
            t[i] = new Thread(new Run(new Share(fb, startX, startX += part, lastThread)));
            t[i].start();
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            int lines = this.CalcLines(Median.this.radius);
            int maxArray = lines * lines;
            int safe = Median.this.radius;
            if (this.share.lastThread) {
                safe = 0;
                this.share.endHeight = this.share.fastBitmap.getHeight();
            }
            if (this.share.fastBitmap.isGrayscale()) {
                int[] avgL = new int[maxArray];
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int c = 0;
                        for (int i = 0; i < lines; ++i) {
                            int Xline = x + (i - Median.this.radius);
                            for (int j = 0; j < lines; ++j) {
                                int Yline = y + (j - Median.this.radius);
                                if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth()) continue;
                                avgL[c] = Median.this.copy.getGray(Xline, Yline);
                                ++c;
                            }
                        }
                        Arrays.sort(avgL, 0, c);
                        int median = c / 2;
                        this.share.fastBitmap.setGray(x, y, avgL[median]);
                    }
                }
            } else {
                int[] avgR = new int[maxArray];
                int[] avgG = new int[maxArray];
                int[] avgB = new int[maxArray];
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int c = 0;
                        for (int i = 0; i < lines; ++i) {
                            int Xline = x + (i - Median.this.radius);
                            for (int j = 0; j < lines; ++j) {
                                int Yline = y + (j - Median.this.radius);
                                if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth()) continue;
                                avgR[c] = Median.this.copy.getRed(Xline, Yline);
                                avgG[c] = Median.this.copy.getGreen(Xline, Yline);
                                avgB[c] = Median.this.copy.getBlue(Xline, Yline);
                                ++c;
                            }
                        }
                        Arrays.sort(avgR, 0, c);
                        Arrays.sort(avgG, 0, c);
                        Arrays.sort(avgB, 0, c);
                        int median = c / 2;
                        this.share.fastBitmap.setRGB(x, y, avgR[median], avgG[median], avgB[median]);
                    }
                }
            }
        }

        private int CalcLines(int radius) {
            return radius * 2 + 1;
        }
    }
}

